import { useCallback } from 'react'
import { checkIsMember } from 'tbcc-sdk-ts/lib/utils'
import { showToast } from '@tarojs/taro'
import API from '@/api'
import {receiveEnamePrize, receiveMemberEname, receiveObjectPrize } from 'tbcc-sdk-ts/lib/request/capiFn'
import { PRIZE_TYPE, BENEFIT_TYPE, DRAW_STATUS } from '@/config/myPrize.config'
import config from '@/config/config'

const useReceive = (props) => {
  const { successMsg = '领取成功', errorMsg = '' } = props
  const receivePrize = async(item, callbackObj={vipCallback:()=>{},updateCallback:()=>{},closeCallback:()=>{}}) => {
    const app = getApp();
    const { activityId } = app
    const { type, id, ename = '', benefitType } = item

    if(type === PRIZE_TYPE.CREDITS || (type === PRIZE_TYPE.ENAME && benefitType === BENEFIT_TYPE.MEMBER)) {
        const isVip = await checkIsMember()
        if(!isVip) {
          showToast({ title: '需加入会员才能领取成功哦', duration: 1000, success: ()=>{callbackObj.vipCallback && callbackObj.vipCallback()} })
          return;
        }
    }
    const receiveFn = {
        [PRIZE_TYPE.ENAME]: async () => {
          if(benefitType === BENEFIT_TYPE.MEMBER) {
           await receiveMemberEname(API.receiveMemberEname,{params: { sellerId: config.sellerId, ename, id, status: DRAW_STATUS.SUCCESS }, successMsg, errorMsg })
          }else {
            await receiveEnamePrize(API.receiveEnamePrize, {params: { id }, successMsg, errorMsg })
          }
        },
        [PRIZE_TYPE.OBJECT]: async () => {
          await receiveObjectPrize(API.receiveObjectPrize, {params: { id }, successMsg, errorMsg })
        },
        [PRIZE_TYPE.CREDITS]: async () => {
          await receiveEnamePrize(API.receiveEnamePrize, {params: { id }, successMsg, errorMsg })
        }
    }
    await receiveFn[type]()
    //  更新奖品列表
    callbackObj.updateCallback && callbackObj.updateCallback();

    callbackObj.closeCallback && callbackObj.closeCallback();
  }

  return {
    receivePrize
  }
}

export default useReceive
