import cloud from '@tbmp/mp-cloud-sdk'
import { Component } from 'react'
import './app.less'
// 使用taro-ui 按需引入的组件样式
import './taro-ui.scss'

import config from './config/config'
import './utils/mdProxy'
import { cloundAlarm } from './utils/dingTalk'

const { env, tornadoAPI, defaultActivityId } = config

cloud.init({ env })

Taro.onError(msg => {
  cloundAlarm(msg, env, requestType)
})

class App extends Component {
  onLaunch(options) {
    console.log('options :>> ', options)
    const { activityId } = options.query || {}
    const app = getApp()
    app.cloud = cloud
    app.tornadoAPI = tornadoAPI
    app.activityId = activityId || defaultActivityId
    app.isOnlineAct = !!activityId
  }
  // 页面后台切前台
  componentDidShow () {}
  // 页面前台切后台
  componentDidHide() {}
  render() {
    return this.props.children
  }
}
export default App
