/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'

/**
 * 检查活动时间
 * 通常用于需在活动时间内才可请求的接口
 *
 * @export
 * @param {IContext<IParams>} context
 * @param {IControllerInfos} { activityInfo }
 * @return {*}  {(Promise<IPreCheckResult}
 */
export default async function checkActivityTime(
  context: IContext<IParams>,
  { activityInfo }: IControllerInfos
): Promise<IPreCheckResult> {
  // 活动不存在
  if (!activityInfo) {
    return resultsModel.error(CODE_TYPES.ERROR_NO_ACTIVITY)
  }
  const { startTime, endTime } = activityInfo
  const currentTime = Date.now()
  if (currentTime < startTime) {
    return resultsModel.error(CODE_TYPES.ERROR_ACTIVITY_NOSTART, `活动未开始`)
  }
  if (currentTime > endTime) {
    return resultsModel.error(CODE_TYPES.ERROR_ACTIVITY_OVER, `活动已结束`)
  }
}
