// 正整数
export const validatePositiveInteger = number => /^[1-9]\d*$/.test(number);

// 整数
export const validateInteger = number => /^-?\d*$/.test(number);

// 判断是否为数字
export const isNumber = val => {

  var regPos = /^\d+(\.\d+)?$/; //非负浮点数
  var regNeg = /^(-(([0-9]+\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\.[0-9]+)|([0-9]*[1-9][0-9]*)))$/; //负浮点数
  if(regPos.test(val) && regNeg.test(val)){
      return true;
  }else{
      return false;
  }

}

 /**
 *
 * 验证一定范围内数,支持整数或小数
 * @param {*} number 
 * @param {*} [ min, max ] 范围    [0,99]  [-Infinity, 0]  [999, Infinity]
 * @param {number} [fixed=0] 小数位数  0时为整数
 * @returns { boolean }
 */
export const validateRangeNumber = (number, [ min, max ] = [], fixed = 0) => {
  const pattern = new RegExp(`^-?[0-9]+(\\.[0-9]{0,${fixed}})?$`);

  if(min > max) {
    console.error('数字范围的最小值不能大于最大值');
    return;
  }
  if(!pattern.test(number) || number === '') return false;

  if(number < min || number > max) return false;

  return true;
}

