import moment from 'moment';
import {
  getActivityList,
  delActivity,
  findWinnerInfoList,
  sellerSave,
  uploadDataCreateFile
} from '/api';
import { activityURL } from '../../../config';
import { activityType } from '../const';
import { setClipboard } from '/utils'
const { cloud } = getApp();
const { function: fc } = cloud;

Component({
  mixins: [],
  data: {
    confirmDialog: {
      visible: false,
      content: '删除活动后该活动用户参与信息将全部删除，确认删除吗？'
    },
    winnerListDialogVisible: false,
    winnerList: [],
    deleteId: '',
    selectedItem: '',
    dataSource: [],
    pageInfo: {
      pageNo: 1,
      pageSize: 10,
      total: 0
    },
    isLoadingList: false,
    showWinning: false
  },
  props: {},
  didMount() {
    this.getList();
  },
  methods: {
    /**
     *获取活动列表
     *
     * @param {number} [currentPage=1] 页数
     * @param {number} [size=10] 页码尺寸
     * @returns {void}
     */
    async getList(currentPage = 1, size = 10) {
      this.setData({ isLoadingList: true });
      try {
        const { success, data, message } = await getActivityList({
          pageNo: currentPage,
          pageSize: size,
          activityType
        })
        this.setData({ isLoadingList: false })

        if (!success) {
          my.showToast({
            type: 'fail',
            content: message
          })
          return;
        }

        const { list, pageNo, pageSize, total } = data;


        this.setData({
          dataSource: list,
          pageInfo: {
            pageNo,
            pageSize,
            total
          }
        })

      } catch (error) {
        this.setData({
          isLoadingList: false
        })
      }

    },
    // 导出中奖名单
    async exportWinnerList(evt) {
      const { activityId } = evt.target.dataset.x.record;
      my.showLoading({ content: '生成文件中...' })
      try {
        const { success, data, message } = await uploadDataCreateFile({
          activityId,
          activityType
        })
        my.hideLoading();

        if (success) {
          await setClipboard({ text: data.url.replace(/amp;/g, '') })
          my.showToast({
            type: 'success',
            content: '中奖名单链接复制成功,请在浏览器中打开下载'
          });
        } else {
          my.showToast({
            type: 'fail',
            content: message
          })
        }
      } catch (error) {

        my.hideLoading();
        console.log(error, 'exportList-error');
      }


    },
    // 复制链接
    async onCopyLink(evt) {
      const { activityId } = evt.target.dataset.x.record;
      try {
        await setClipboard({
          text: `${activityURL}&activityId=${activityId}`
        })
        my.showToast({
          type: 'success',
          content: '复制活动链接成功'
        })
      } catch (error) {
        console.log(error)
      }
      
    },
    onCloseConfirmDialog() {
      this.setData({
        confirmDialog: Object.assign({},
          this.data.confirmDialog, {
            visible: false
          })
      })
    },
    // 点击列表删除
    handleTapDelete(evt) {
      const { activityId } = evt.target.dataset.x.record;

      this.setData({
        confirmDialog: Object.assign({}, this.data.confirmDialog, {
          visible: true
        }),
        deleteId: activityId
      })
    },
    onConfirmDelete() {
      const activityId = this.data.deleteId;

      this.setData({
        confirmDialog: Object.assign({}, this.data.confirmDialog, {
          visible: false
        })
      })

      activityId && this.deleteActivityFromId(activityId)
    },
    // 删除活动
    async deleteActivityFromId(activityId) {
      try {
        const { success, message } = await delActivity({ activityId, activityType });
        if (success) {
          this.getList()
        } else {
          my.showToast({
            type: 'fail',
            content: message
          })
        }
      } catch (error) {
        console.log(err)
      }
    },
    // 编辑
    handleClickEdit(evt) {
      let { activityId } = evt.target.dataset.x.record;
      this.$page.$router.push(`/activity/edit/${activityId}`)
    },
    changePagination(evt) {
      const { value } = evt.detail;
      this.getList(value)
    },
    // 创建活动
    tapname() {
      this.$page.$router.push('/activity/add')
    }
  },
});