/**
 * 简易API封装
 * @param methodName 
 * @param params 
 * @param name
 */
export const promisifyApiSimple = (methodName: string, params: IParamJSAPI, name?: string) => {
    if(name) {
        // @ts-ignore
        my[methodName](name,params);
        return;
    }
    // @ts-ignore
    my[methodName](params);
}
/**
 * 通用API封装
 * @param methodName 
 * @param params 
 */
export const promisifyApi =  (methodName: string, params = {}) => {
	return new Promise((resolve, reject) => {
        // @ts-ignore
		my[methodName]({
			...params,
			success: res => {
				resolve(res)
			},
			fail: err => {
				reject(err)
			}
		})
	})
}

/**
 * 通用API封装
 * @param methodName 
 * @param params 
 */
export const confirmPromisifyApi =  async (title: string, content: string, successCb?: any) => {
	return new Promise((resolve, reject) => {
      // @ts-ignore
        my.confirm({
          title,
          content,
          confirmButtonText: '确定',
          cancelButtonText: '取消',
          success: async (result) => {
            const { confirm } = result;
            if (confirm && successCb) {
              const cbResult = await successCb();
              resolve(cbResult)
            }
            resolve(false)
          },
        });
    })
}
/**
 * 通用API封装
 * @param methodName 
 * @param params 
 */
export const promisifyApiToTb =  (methodName: string, params = {}) => {
	return new Promise((resolve, reject) => {
    // @ts-ignore
		my.tb[methodName]({
			...params,
			success: res => {
				resolve(res)
			},
			fail: err => {
				reject(err)
			}
		})
	})
}
/**
 * 创建音频类
 */
export class AudioModel {
    constructor(opts: { src: string }) {
      const { src } = opts;
      if (!src) {
        console.error('请输入音频链接');
        return false;
      }
      try {
        // @ts-ignore
        const innerAudioContext = my.createInnerAudioContext();
        Object.keys(opts).forEach(item => {
            innerAudioContext[item] = opts[item];
        });
        return innerAudioContext;
      } catch (e) {
        console.error('当前版本不支持音频');
      }
    }
}
/**
 * 获取天猫会员状态
 */
export const getTmallMemberStatus = async () => {
  // @ts-ignore
  const { cloud } = app;
  return (await cloud.topApi.invoke({
      api: "tmall.campus.industry.app.audit.query",
      data: {
        source: "duibajk",
      },
    }).catch((err) => {
      console.log(err);
  })) || {};
}
/**
 * 拉菲奖品发放
 * @param params 
 */
export const strategyEname = async (params: { channel: string, strategyCode: string, code: string }) => {
  // @ts-ignore
  const { cloud } = app;
  return (await cloud.topApi.invoke({
    api: "alibaba.latour.strategy.issue",
    data: {
      channel: params.channel || "",
      strategy_code: params.strategyCode || "",
      selected_benefit_code: params.code || "",
    },
  }).catch((err) => {
    console.log("err", err);
  })) || {}
}
/**
 * loading
 * @param methodName 
 * @param params 
 * @param name
 */
export const isLoading = (methodName: string) => {
  // @ts-ignore
  my[methodName]();
}
/**
 * 数据请求
 * @param params 
 * @param loading
 */
export const myRequest = async (params: any, handle: string, loading: boolean) => {
  return new Promise((resolve, reject) => {
    // @ts-ignore
    my.request(params).then(({ data: res }) => {
      console.log(`调用${handle}接口返回结果`, res)
      loading && isLoading('hideLoading')
      if (res && res.success) {
        resolve(res);
      } else {
        reject(res);
      }
    }).catch((e) => {
      loading && isLoading('hideLoading')
      console.log(e)
      reject();
    });
  })
}
/**
 * 云函数接口请求
 * @param _cloudName 
 * @param handle 
 * @param params 
 * @param loading 
 */
export const cloudRequest = async (cloud: any, _cloudName:string, handle: string, params: any, loading: boolean) => {
  return new Promise((resolve, reject) => {
    // @ts-ignore
    cloud.function.invoke(_cloudName, params, handle).then(res => {
      console.log(`调用${handle}接口返回结果`, res)
      loading && isLoading('hideLoading')
      if (res && res.success) {
        resolve(res);
      } else {
        reject(res);
      }
      return res;
    }).catch(() => {
      loading && isLoading('hideLoading')
      reject();
    });
  });
}