"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var tb = require("./core/tb");
var tbFn = require("./core/tbFn");
var tbMock = require("./core/tbMock");
var utils = require("./utils");
var constants = require("./constants");
var capi_1 = require("./request/capi");
var capiFn_1 = require("./request/capiFn");
var request_1 = require("./request");
var isH5 = 'undefined' !== typeof window;
// 如果为h5环境走mock数据
var _tb = {};
Object.entries(__assign(__assign({}, tb), tbFn)).forEach(function (_a) {
    var key = _a[0], value = _a[1];
    _tb[key] = isH5 ? tbMock[key] : value;
});
exports.default = {
    capi: capi_1.default,
    capiFn: capiFn_1.default,
    tb: _tb,
    utils: utils,
    request: request_1.default,
    constants: constants
};
//# sourceMappingURL=index.js.map