"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.textRiskIdentification = exports.chattingSendCard = exports.getUserAddress = exports.openDetail = exports.checkGoodsCollectedStatus = exports.collectGoods = exports.getServerTime = exports.redirectTo = exports.navigateTo = exports.navigateToOutside = exports.checkShopFavoredStatus = exports.favorShop = exports.getSystemInfo = exports.getAuthUserInfo = exports.simpleAlert = exports.commonToast = void 0;
/**
 * 通用toast
 * @param {string} content toast内容
 * @param {number} duration 显示时长
 * @param {function} successCb 成功回调
 */
exports.commonToast = function (content, duration, successCb) {
    if (duration === void 0) { duration = 3000; }
    return '暂不支持toast';
};
/**
 * 简易alert
 * @param {string} content toast内容
 */
exports.simpleAlert = function (content) {
    alert(content);
};
/**
 * 获取授权用户信息
 * @returns {object} 用户登录信息
 */
exports.getAuthUserInfo = function () { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, {
                nickName: 'nickName',
                avatar: '123',
                mixNick: '1234'
            }];
    });
}); };
/**
 * 获取系统信息
 * @returns {object} 小程序系统信息
 */
exports.getSystemInfo = function () { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, {
                version: '9.5.0'
            }];
    });
}); };
/**
 * 执行关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
exports.favorShop = function (sellerId) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        if (!sellerId) {
            console.error('favorShop: 请传入卖家Id');
            return [2 /*return*/, false];
        }
        return [2 /*return*/, true];
    });
}); };
/**
 * 判断是否关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
exports.checkShopFavoredStatus = function (sellerId) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        if (!sellerId) {
            console.error('checkShopFavoredStatus: 请传入卖家Id');
            return [2 /*return*/, false];
        }
        return [2 /*return*/, true];
    });
}); };
/**
 * 跳转到外部链接
 * @param {string} url 跳转链接
 */
exports.navigateToOutside = function (url) {
    if (!url) {
        console.error('navigateToOutside: 请传入url');
        return false;
    }
    window.location = url;
};
/**
 * 跳转到内部链接（新开窗口）
 * @param {string} url 跳转链接
 */
exports.navigateTo = function (url) {
    if (!url) {
        console.error('navigateTo: 请传入url');
        return false;
    }
    window.location = url;
};
/**
 * 跳转到内部链接（不新开窗口）
 * @param {string} url 跳转链接
 */
exports.redirectTo = function (url) {
    if (!url) {
        console.error('redirectTo: 请传入url');
        return false;
    }
    // @ts-ignore
    window.replace(url);
};
/**
 * 获取服务器时间
 * @returns {number} 服务器时间戳
 */
exports.getServerTime = function () { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, +new Date()];
    });
}); };
/**
 * 收藏商品
 * @param {number} 商品id
 * @returns {object} 收藏结果
 */
exports.collectGoods = function (id) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        if (!id) {
            console.error('collectGoods: 请传入商品id');
            return [2 /*return*/, false];
        }
        return [2 /*return*/, true];
    });
}); };
/**
 * 查询商品收藏状态
 * @param {number} 商品id
 * @returns {boolean} 商品收场状态
 */
exports.checkGoodsCollectedStatus = function (id) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        if (!id) {
            console.error('checkGoodsCollectedStatus: 请传入商品id');
            return [2 /*return*/, false];
        }
        return [2 /*return*/, true];
    });
}); };
/**
 * 跳转到淘宝商品页
 * @param {string} itemId 商品ID
 */
exports.openDetail = function (itemId) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        if (!itemId) {
            console.error('openDetail: 请传入商品id');
            return [2 /*return*/, false];
        }
        // @ts-ignore
        window.location = 'https://item.taobao.com/item.htm?id=' + itemId;
        return [2 /*return*/];
    });
}); };
/**
 * 获取淘宝用户收货地址
 */
exports.getUserAddress = function (opts) {
    if (opts === void 0) { opts = {}; }
    return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2 /*return*/, {
                    name: 1,
                    phone: 1,
                    address: 123
                }];
        });
    });
};
/**
 * 分享到群聊卡片
 * @param {object} requestInfo 分享到群聊卡片所需请求参数
 */
exports.chattingSendCard = function (requestInfo) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        alert('无法模拟');
        return [2 /*return*/, false];
    });
}); };
/**
 * 分享到群聊卡片
 * @param {*} cloud 小程序云
 * @param {object} requestInfo 分享到群聊卡片所需请求参数
 */
exports.textRiskIdentification = function (text) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2 /*return*/, true];
    });
}); };
//# sourceMappingURL=tbMock.js.map