'use strict';
import API from "/api";
import { SELLER_ID } from '../../constants';

const app = getApp();
const { tbccTs } = app;
const { commonToast, navigateToOutside, getUserAddress, setClipboard } = tbccTs.tb;
const { dateFormatter, throttleHandle, checkMember } = tbccTs.utils;
const { PRIZE_TYPE, DRAW_STATUS } = tbccTs.constants;
// 我的奖品配置项
const prizeConfig = {
  bg: '//yun.duiba.com.cn/aurora/assets/e13fab3165d3a6bb4cbe8827e8f0fd41084b0091.png', //背景图
  title: '//yun.dui88.com/duiba-components-c-myprizeprize_title.png',//标题
  copyIcon: '//yun.dui88.com/duiba-components-c-myprizemyprize_copy_code.png', //复制
  receiveBtn: '//yun.duiba.com.cn/bestoreBox/prize_received.png', //已领取 权益类奖品未配置 uesUrl使用
  commonStatus: {
    6: '//yun.dui88.com/duiba-components-c-myprizeget_again.png', //重新领取
    5: '//yun.duiba.com.cn/spark/assets/914ba8643c8abb8d710a3126ec312aecf6c4daf0.png', //已失效
    4: '//yun.duiba.com.cn/spark/assets/8267375232058a6d0140270b1594427fb08d6ae3.png', //领取失败
  },
  objectStatus: {
    1: '//yun.dui88.com/duiba-components-c-myprizeto_address.png', //填写地址(实物奖品)
    3: '//yun.dui88.com/duiba-components-c-myprizelogistics.png', //查看物流
  },
  enameStatus: {
    1: '//yun.dui88.com/duiba-components-c-myprizeget_now.png', //立即领取(除实物奖品外)
    3: '//yun.duiba.com.cn/bestoreBox/prize_received.png', //去使用(除实物奖品外)  
  },
  logisticsImage: {
    shipped: '//yun.dui88.com/duiba-components-c-myprizeprize_shipped.png', // 已发货物理弹窗
    notShipped: '//yun.dui88.com/duiba-components-c-myprizenotshipped.png', // 待发货物流弹窗
  },
  btnStyle: {// 按钮宽度
    width: '150rpx'
  },
  contentTop: '260rpx',// 列表距离头部高度
  blankTxt: '暂无奖品',
  hasLogistic: true, // 是否展示物流信息
  isShowPirzeId: true, // 是否显示奖品编号
  memberShopVisible: false, // 入会插件
}
Page({
  data: {
    PRIZE_TYPE,
    DRAW_STATUS,
    myPrizeList: [], //我的奖品
    endTime: null,//到期时间
    prizeConfig: prizeConfig,
    objectStatus: {
      ...prizeConfig.commonStatus,
      ...prizeConfig.objectStatus
    },
    enameStatus: {
      ...prizeConfig.commonStatus,
      ...prizeConfig.enameStatus
    },
    logisticsImage: {
      ...prizeConfig.logisticsImage,
      copyIcon: prizeConfig.copyIcon
    },
    hasLogistic: prizeConfig.hasLogistic,
    isShowPirzeId: prizeConfig.isShowPirzeId,
    isLogisticModal: false,
    currentPrize: {}
  },
  onLoad() {
    this.getMyPrize();
  },
  onShow() {
  },
  // 到期时间
  getEndTime(endTime) {
    if (!endTime) return null
    this.setData({
      endTime: dateFormatter(endTime, 'yyyy/MM/dd hh:mm:ss')
    })
    console.log(this.data.endTime)
  },

  /**
 * 获取奖品列表
 * @param {string}
 */
  async getMyPrize() {
    const { activityId } = app;
    const { success, data } = await API.getMyPrizeList({ activityId }).catch(res => {
      commonToast(res && res.message);
    }) || {};
    if (success && data) {
      const { list } = data
      this.setData({
        myPrizeList: list
      })
      const endTime = list && list[0] && list[0].expiredTime
      this.getEndTime(endTime)
    }
  },

  //领取奖品
  handleClick: throttleHandle(async function(e) {
    const { type, drawStatus, useUrl = '', id, _id } = e.target.dataset.item
    const { hasLogistic } = this.data

    if(drawStatus == 3) {
      if(type == PRIZE_TYPE.OBJECT && hasLogistic) {
        this.setData({ currentPrize: e.target.dataset.item, isLogisticModal: true })
        return;
      }
      if(type != PRIZE_TYPE.OBJECT && useUrl) {
        navigateToOutside(useUrl)
        return;
      }
    }
    if(!(drawStatus == 6 || drawStatus == 1)) {
      return;
    }
    // 领取权益
    const prizeId = id || _id
    if (type === PRIZE_TYPE.ENAME || type === PRIZE_TYPE.OBJECT) return this.handleGetPrize(type,prizeId)
    // 领取积分
    if (type === PRIZE_TYPE.CREDITS) return this.handleGetIntergation(prizeId)
  },2000),
  // 优惠券 实物
  async handleGetPrize(type,id) {
    const { activityId } = app;
    const success = type === PRIZE_TYPE.ENAME ? (await API.fn.receiveEnamePrize({ activityId, id })) :
          type === PRIZE_TYPE.OBJECT ? (await API.fn.receiveObjectPrize({ activityId, id })) : false

    if (success) {
      commonToast('领取成功')
    }
    this.getMyPrize()
  },
  // 积分
  async handleGetIntergation(id) {
    // 判断是否为会员
    // const isVip = await API.fn.getVipInfo({ activityId })
    const isMember = await checkMember(SELLER_ID)
    if (!isMember) {
      // commonToast('需加入会员才能领取成功哦', 2000,() => { navigateToOutside(url) });
      commonToast('需加入会员才能领取成功哦', 2000,() => { this.setData({ memberShopVisible: true }) });
      return;
    }
    const { activityId } = app;
    const success = await API.fn.receiveEnamePrize({ activityId, id })

    if (success) {
      commonToast('领取成功')
    }
    this.getMyPrize()
  },

  // 复制编码
  async handleCopyId(e) {
    const { text } = e.target.dataset || {}
    await setClipboard({ text })
    commonToast('复制成功')
  },
  /**
  * 关闭物流弹窗
  */
  closeLogisticModal() {
    this.setData({ isLogisticModal: false })
  },

  // 关闭入会组件
  closeCommonModal() {
    this.setData({ memberShopVisible: false })
  },
  // 入会成功
  onSuccess() {
    this.setData({ memberShopVisible: false })
  }
});