/**
 * 通用toast
 * @param {string} content toast内容
 * @param {number} duration 显示时长
 * @param {function} successCb 成功回调
 */
export const commonToast = (content, duration = 3000, successCb) => {
    return '暂不支持toast';
};
/**
 * 简易alert
 * @param {string} content toast内容
 */
export const simpleAlert = content => {
    alert(content);
};
/**
 * 获取授权用户信息
 * @returns {object} 用户登录信息
 */
export const getAuthUserInfo = async () => {
    return {
        nickName: 'nickName',
        avatar: '123',
        mixNick: '1234'
    };
};

/**
 * 获取系统信息
 * @returns {object} 小程序系统信息
 */
export const getSystemInfo = async () => {
    return {
        version: '9.5.0'
    };
};
/**
 * 执行关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
export const favorShop = async sellerId => {
    if (!sellerId) {
        console.error('favorShop: 请传入卖家Id');
        return false;
    }
    return true;
};
/**
 * 判断是否关注店铺
 * @param {number} sellerId 店铺归属的卖家Id
 * @returns {boolean} 关注状态
 */
export const checkShopFavoredStatus = async sellerId => {
    if (!sellerId) {
        console.error('checkShopFavoredStatus: 请传入卖家Id');
        return false;
    }
    return true;
};
/**
 * 跳转到外部链接
 * @param {string} url 跳转链接
 */
export const navigateToOutside = url => {
    if (!url) {
        console.error('navigateToOutside: 请传入url');
        return false;
    }
    window.location = url;
};
/**
 * 跳转到内部链接（新开窗口）
 * @param {string} url 跳转链接
 */
export const navigateTo = url => {
    if (!url) {
        console.error('navigateTo: 请传入url');
        return false;
    }
    window.location = url;
};

/**
 * 跳转到内部链接（不新开窗口）
 * @param {string} url 跳转链接
 */
export const redirectTo = url => {
    if (!url) {
        console.error('redirectTo: 请传入url');
        return false;
    }
    // @ts-ignore
    window.replace(url);
};
/**
 * 获取服务器时间
 * @returns {number} 服务器时间戳
 */
export const getServerTime = async () => {
    return +new Date();
};
/**
 * 收藏商品
 * @param {number} 商品id
 * @returns {object} 收藏结果
 */
export const collectGoods = async id => {
    if (!id) {
        console.error('collectGoods: 请传入商品id');
        return false;
    }
    return true;
};
/**
 * 查询商品收藏状态
 * @param {number} 商品id
 * @returns {boolean} 商品收场状态
 */
export const checkGoodsCollectedStatus = async id => {
    if (!id) {
        console.error('checkGoodsCollectedStatus: 请传入商品id');
        return false;
    }
    return true;
};
/**
 * 跳转到淘宝商品页
 * @param {string} itemId 商品ID
 */
export const openDetail = async itemId => {
    if (!itemId) {
        console.error('openDetail: 请传入商品id');
        return false;
    }
    // @ts-ignore
    window.location = 'https://item.taobao.com/item.htm?id=' + itemId;
};
/**
 * 获取淘宝用户收货地址
 */
export const getUserAddress = async (opts = {}) => {
    return {
        name: 1,
        phone: 1,
        address: 123
    }
};
/**
 * 分享到群聊卡片
 * @param {object} requestInfo 分享到群聊卡片所需请求参数
 */
export const chattingSendCard = async (requestInfo) => {
    alert('无法模拟');
    return false;
};
/**
 * 分享到群聊卡片
 * @param {*} cloud 小程序云
 * @param {object} requestInfo 分享到群聊卡片所需请求参数
 */
export const textRiskIdentification = async (text) => {
    return true;
}