import API from '../../api';
import { SELLER_ID, STAT_TYPE } from '../../constants';
const app = getApp();
const { tbccTs } = app;
const { throttleHandle } = tbccTs.utils;
const { commonToast, favorShop, navigateTo, navigateToOutside, showSharePanel } = tbccTs.tb;

const taskConfig = {
  taskStatus: { // 任务状态
    1: '//yun.duiba.com.cn/baicaoweiFarmer/task_btn_01.png',
    2: '//yun.duiba.com.cn/baicaoweiFarmer/task_btn_02.png',
    3: '//yun.duiba.com.cn/baicaoweiFarmer/task_btn_03.png'
  },
  taskIcon: {// 任务图标
    follow: '//yun.duiba.com.cn/baicaoweiFarmer/follow.png',
    member: '//yun.duiba.com.cn/baicaoweiFarmer/memberStar1.png',
    invites: '//yun.duiba.com.cn/baicaoweiFarmer/invites.png',
    jumpLink: '//yun.duiba.com.cn/baicaoweiFarmer/browseGoodsLink.png',
    browseGoods: '//yun.duiba.com.cn/baicaoweiFarmer/browseGoods.png',
    orderGoods: '//yun.duiba.com.cn/baicaoweiFarmer/orderGoods.png',
    collectGoods: '//yun.duiba.com.cn/baicaoweiFarmer/orderGoods.png',
    sign: '//yun.duiba.com.cn/baicaoweiFarmer/orderGoods.png',
  },
  commonTaskTxt: {
    1: '去完成',
    2: '待领取',
    3: '已完成'
  },
  doTaskTxt: {
    follow: '立即关注',
    invites: '去邀请',
    member: '1秒入会',
    sign: '立即签到',
    jumpLink: '去完成',
    browseGoods: '去完成',
    orderGoods: '去完成',
    collectGoods: '去完成',
  },
  browseType: 1, // 1 跳转即算完成 2 跳转浏览15s 才算完成
  browseTime: 15, // 浏览时间
}
Component({
  mixins: [],
  data: {
    taskStatus: taskConfig.taskStatus,
    taskIcon: taskConfig.taskIcon,
    commonTaskTxt: taskConfig.commonTaskTxt,
    doTaskTxt: taskConfig.doTaskTxt,
    taskList: [
      { 
        taskType: 'follow',
        title: '关注店铺',
        taskRateType: 1,
        times: 1,
        completeTimes: 0,
        status: 1,
        rewards: 1
      },
      { 
        taskType: 'member',
        title: '加入会员',
        taskRateType: 1,
        times: 1,
        completeTimes: 0,
        status: 1,
        rewards: 1
      },
      { 
        taskType: 'invites',
        title: '邀请好友入会',
        taskRateType: 1,
        times: 3,
        completeTimes: 0,
        status: 1,
        rewards: 1
      },
      { 
        taskType: 'jumpLink',
        title: '浏览店铺15s',
        taskRateType: 2,
        times: 1,
        completeTimes: 0,
        status: 1,
        rewards: 1
      },
      { 
        taskType: 'browseGoods',
        title: '浏览商品',
        taskRateType: 2,
        times: 1,
        completeTimes: 0,
        status: 1,
        rewards: 1
      },
      { 
        taskType: 'orderGoods',
        title: '下单任务',
        taskRateType: 2,
        times: 1,
        completeTimes: 0,
        status: 1,
        rewards: 1
      },
      { 
        taskType: 'collectGoods',
        title: '收藏商品',
        taskRateType: 2,
        times: 1,
        todayCompleteTimes: 0,
        status: 1,
        rewards: 1
      },
      { 
        taskType: 'sign',
        title: '每日签到',
        taskRateType: 2,
        times: 1,
        todayCompleteTimes: 0,
        status: 1,
        rewards: 1
      }
    ],
    memberShopVisible: false,
    currentTaskType: null,
    preBrowseTime: null
  },
  props: {
    taskFlag: 1,
    dataName: '',
    onModalClose: () => {},
    onUpdate: () => {}
  },
  didMount() {
    this.getTaskList()
  },
  didUpdate(preProps,preData) {
    const { taskFlag } = this.props
    const { isFlashTask = false } = app
    const { browseTime } = taskConfig
    const { preBrowseTime, currentTaskType } = this.data
    if(preProps.taskFlag !== taskFlag && isFlashTask) {
      // console.log((Date.now() - preBrowseTime)/1000)
      if(preBrowseTime && ((Date.now() - preBrowseTime) / 1000) >= browseTime) {
        this.doCompleteTask(currentTaskType,true)
      }
      else {
        if(preBrowseTime && currentTaskType) {
          this.setData({ preBrowseTime: null, currentTaskType: null })
          commonToast('未达到15秒')
        }
        this.getTaskList(true)
      }
    }
  },
  didUnmount() {
  },
  methods: {
    // 关闭弹窗
    onModalClose() {
      const { onModalClose, dataName } = this.props;
      onModalClose && onModalClose(dataName);
    },

    // 按钮
    handleTapItem: throttleHandle(async function(e) {
      const { activityId } = app
      const { status, taskType, url, rewards, itemIds, keepTime } = e.target.dataset.item
      if(status == 3) return;

      if(status == 2) {
        const { success, data } = await API.receiveTaskRewards({ activityId, taskType }).catch(res => {
          commonToast(res && res.message);
        }) || {};
    
        if (success && data) {
          const { rewards, receiveTimes } = data
          let message = taskType == 'invites' ? 
          `成功邀请${receiveTimes}名好友，抽盒次数+${rewards}`:`抽盒次数+${rewards}`

          commonToast(message)
          this.getTaskList()
          this.props.onUpdate()
        }
      }
      else {
        this.goToComplete(taskType,url,itemIds,keepTime)
      }
    },2000),

    // 做任务
    async goToComplete(taskType,url,itemIds,keepTime) {
      const { activityId } = app
      const { browseType } = taskConfig
      switch(taskType) {
        case 'member':
          // 去加入会员
          this.setData({ memberShopVisible: true })
          break;
        case 'follow':
          let isFollow = await favorShop(SELLER_ID)
          if(isFollow) {
            this.doCompleteTask(taskType)
          }
          break;
        case 'invites':
          // 邀请好友
          showSharePanel();
          await API.fn.addStat(activityId, STAT_TYPE.GO_TO_INVITE)
          break;
        case 'jumpLink':
          // 跳转任务
          navigateToOutside(url || 'https://www.feizhu.com')
          if(browseType === 1) {
            this.doCompleteTask(taskType)
          }
          else {
            app.isFlashTask = true
            this.setData({ preBrowseTime: Date.now(), currentTaskType: taskType})
          }
          break;
        case 'browseGoods':
          // 跳转浏览页面
          app.isFlashTask = true
          navigateTo(`/pages/browseGoods/browseGoods?itemIds=${itemIds}&keepTime=${keepTime}`)
          break;
        case 'orderGoods': 
          // 跳转下单页面
          app.isFlashTask = true
          navigateTo(`/pages/orderGoods/orderGoods?itemIds=${itemIds}`)
          break;
        case 'collectGoods': 
          // 跳转收藏页面
          app.isFlashTask = true
          navigateTo(`/pages/collectGoods/collectGoods?itemIds=${itemIds}`)
          break;
        case 'sign': 
          // 签到
          this.doCompleteTask(taskType)
          break;
      }
    },

    // 完成任务
    async doCompleteTask(taskType, flag) {
      const { activityId } = app

      let { success, data } = await API.doCompleteTask({ activityId, taskType }) || {}
      if(success) {
        this.getTaskList()
        flag && this.setData({ preBrowseTime: null })
      }
    },

    // 获取任务列表
    async getTaskList(flag) {
      const { activityId } = app

      const { success, data } = await API.getTaskList({ activityId }).catch(res => {
        commonToast(res && res.message);
      }) || {};

      if (success && data) {
        const { list } = data
        app.isFlashTask = flag ? false : true
        // this.setData({ taskList: list })
      }
    },

    // 关闭入会组件
    closeCommonModal() {
      this.setData({ memberShopVisible: false })
    },
    // 入会成功
    onSuccess() {
      this.getTaskList()
      this.setData({ memberShopVisible: false })
    }
  },
});
