const app = getApp();
const { tbccTs, cloudName, cloud, requestType } = app;

const { utils: { generateAPI }, request: tbccRequest, capi, capiFn } = tbccTs;

const request = tbccRequest({
  cloud,
  cloudName,
  requestType
});

// api handle 列表
const apiList = {
  ...capi,
  getActivityBaseInfoById: {
    handle: 'getActivityBaseInfoById',
    method: 'GET',
    isShowLoading: false
  },
  login: 'login',
  getTaskList: 'getTaskList',
  doCompleteTask: 'doCompleteTask',
  receiveTaskRewards: 'receiveTaskRewards',
  addStat: 'addStat',
  doHelp: 'doHelp',
};

// 生成API
const API = generateAPI(apiList, request);
API['fn'] = capiFn(apiList, request);

export default API;
