/**
   * 任务类型（taskType）: collectGoods 、 orderGoods 、 browseGoods 、exchangeCredits
   * task: {
   *  itemId: //商品ID
   *  taskType: //任务类型
   *  type: //头部样式（02——banner，01——标题）
   *  image: {//图片
   *    bg: //集合页背景
   *    banner: //头部banner
   *    title: //头部title
   *    collect: //商品以收藏
   *    no_collect: //商品未收藏
   *  }
   *  color: //商品名称：文字颜色
   * }
 */
import API from '../../api';
const app = getApp();
const { tbcc } = app;
const { commonToast } = tbcc.tb;
const completeType = 1  // 1 浏览完成 2 点击任意商品完成

Page({
  timer: null,
  data: {
    completeType: completeType,
    usePercent: 0, // 已进行的进度条
    percent: 0,// 进度条
    isShowCountdown: true, // 是否显示倒计时
    query: {},
    task: {},
    goodsList: []
  },
  onLoad(query) {
    this.query = query || {}
    this.init()
  },
  onShow() {
    //重新回到页面开启倒计时
    if(!this.timer && completeType == 1) {
      this.setData({ usePercent: this.data.percent })
      this.browseGoodsTimes()
      console.log(10 - this.usePercent)
    }
  },
  onHide() {
    // 页面隐藏
    if (this.timer) {
      clearInterval(this.timer)
    }
  },
  onUnload() {
    // 页面被关闭
    if (this.timer) {
      clearInterval(this.timer)
    }
  },
  init() {
    this.setData({
      task: {
        taskType: 'browseGoods',
        type: '01',
        image: {
          bg: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_bg@2x.png',
          banner: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_banner@2x.png',
          title: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_title@2x.png',
          collect: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_collection@2x.png',
          no_collect: '//yun.duiba.com.cn/taobaomini/clientCTest/collection_no_collect@2x.png',
          img: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_img@2x.png',
        },
        color: '#181818'
      }
    })
    this.initPage()
  },
  async initPage() {
    const { activityId } = app
    const { itemIds } = this.query

    const { success, data } = await API.getItemListByItemIds({ activityId, itemIds }).catch(res => {
      res && commonToast(res)
    }) || {}
    if(success) {
       this.setData({ goodsList: data.list || [] })
    }
  },
  //任务完成
  async onCompleteTask(itemId) {
    const { activityId } = app
    let browsResult = await API.doBrowseGoodsTask({ activityId, itemId }).catch(res => {
      res && commonToast(res)
    }) || {}
    if(browsResult.success) {
      commonToast('任务完成，请到任务中心查看奖励')
    }
  },
  /**
   * 跳转商品详情页
   */
  onOpenDetail(itemId = '') {
    if(completeType == 1) {
      this.setData({
        percent: this.data.usePercent,
      }, () => {
        clearInterval(this.timer)
      })
    }
    else {
      this.onCompleteTask(itemId)
    }
  },
  /**
   * 浏览商品倒计时
   */
  browseGoodsTimes() {
    this.timer = setInterval(() => {
      this.setData({
        usePercent: this.data.usePercent + 1
      }, () => {
        if (this.data.usePercent >= 10) {
          this.onCompleteTask()
          clearInterval(this.timer)
        }
      })
    },1000)
  }
});
