import { downloadFile } from "../../../api";
const { cloud } = getApp();
// import { upLoadFileApi } from "../../utils/my-api";
Component({
  data: {
    fileName: "",
    copyLink: false,
    url: "yun.dui88.com/call/example.xlsx",
  },
  props: {
    activityId: "",
    onClose: () => { },
  },
  didMount() {
    console.log(">>>>>>activityId", this.props.activityId);
  },
  didUpdate() { },
  didUnmount() { },
  methods: {
    //LS20200716关闭弹窗
    closeShip() {
      this.props.onClose();
      this.setData({
        fileName: "",
      });
      console.log("ship-dialog====showShip");
    },
    closeDialog() {
      this.setData({});
    },
    //下载示例文件
    async downloadExampleFile() {
      // let urls = await cloud.file.getTempFileURL({  
      //   fileId: ['cloud://E89396D800766AB3D101FD4DF83F5C7D//示例.xlsx']  
      // }) 
      // console.log(urls,'urls');
      // const { url } = urls[0] 
      // this.setData({
      //   copyLink:true,
      //   url:"yun.dui88.com/call/example.xlsx"
      // })
      const { url } = this.data
      my.setClipboard({
        text: url.replace(/amp;/g, ""),
        success(res) {
          my.showToast({
            type: "success",
            content: "下载链接复制成功,请在浏览器中打开下载",
          });
        },
      });
    },
    closeCopyLinkDialog() {
      this.setData({
        copyLink: false
      })
    },
    //20200717确认发货
    //20200717
    async onChangeLoadFile() {
      let { fileName } = this.data;
      let { activityId } = this.props;
      console.log("fileName==", fileName, "activityId===", activityId);
      let result = await downloadFile({ activityId, fileName });
      console.log("-----**", result);
      if (result.success) {
        if (result.data.total == 0) {
          my.showToast({
            type: "fail",
            content: `导入信息错误，请导入正确信息`,
          });
        } else {
          my.showToast({
            type: "success",
            content: `成功导入${JSON.stringify(result.data.total)}条发货信息！`,
          });
          this.props.onClose()
        }
      } else {
        my.showToast({
          type: "fail",
          content: result.message,
        });
      }
    },
    //输入框变化
    onChangeInput(e) {
      console.log("输入框变化", e);
      let { fileName } = this.data;
      this.setData({
        fileName: e.detail.value,
      });
      console.log("====", fileName);
    },
  },
});
