/** @format */

import Utils from 'taobao-mini-sdk/lib/utils/index'
import { BaseDao as CloudBaseDao } from 'taobao-mini-sdk/lib/dao/base.dao'
import TBAPI from 'taobao-mini-sdk/lib/service/TBAPI'
let MockConfig = require('../mockServer/sdk')

const {
  DEFAULT_CODE_TYPES,
  dateFormatter: cloudDateFormatter,
  transformBeijingDate: cloudTransformBeijingDate,
  getStartTimestamp,
  getEndTimestamp,
  ResultsModel
} = Utils

const resultsModel = new ResultsModel()

let env = process.argv[2]
console.log(`env`, env)

export const TBAPIS: typeof TBAPI = env === 'mock' ? MockConfig.TBAPIS : TBAPI

export const BaseDao = env === 'mock' ? MockConfig.BaseDao : CloudBaseDao

export const transformBeijingDate: typeof Utils.transformBeijingDate =
  env === 'mock' ? MockConfig.transformBeijingDate : cloudTransformBeijingDate

export const dateFormatter: typeof Utils.dateFormatter = env === 'mock' ? MockConfig.dateFormatter : cloudDateFormatter

export { DEFAULT_CODE_TYPES, resultsModel, getStartTimestamp, getEndTimestamp }
