"use strict";
/** @format */
Object.defineProperty(exports, "__esModule", { value: true });
exports.signFigures = exports.MathRand = void 0;
function MathRand() {
    var Num = '';
    for (var i = 0; i < 6; i++) {
        Num += Math.floor(Math.random() * 10);
    }
    return Num;
}
exports.MathRand = MathRand;
//小数相乘
var signFigures = function (num, rank) {
    if (rank === void 0) { rank = 6; }
    if (!num)
        return 0;
    var sign = num / Math.abs(num);
    var number = num * sign;
    var temp = rank - 1 - Math.floor(Math.log10(number));
    var ans;
    if (temp > 0) {
        ans = parseFloat(number.toFixed(temp));
    }
    else if (temp < 0) {
        ans = Math.round(number / Math.pow(10, temp)) * temp;
    }
    else {
        ans = Math.round(number);
    }
    return ans * sign;
};
exports.signFigures = signFigures;
//# sourceMappingURL=math.js.map