import React, { useState, useEffect, useRef } from 'react'
import { View } from '@tarojs/components'
import ContainerFit from '@/components/_base/ContainerFit/ContainerFit'
import TitleImg from '@/components/_tb_comps/TitleImg/TitleImg'
import GoodsList from '@/components/_tb_comps/GoodsList/GoodsList'
import { useRouter, showToast } from '@tarojs/taro'
import tbccTs from 'tbcc-sdk-ts'
import API from '@/api'
import { useThrottle } from '@/hooks/useThrottle'
const { checkGoodsCollectedStatus, collectGoods, getSystemInfo } = tbccTs.tb
import styles from './collectGoods.module.less'
import COLLECT_CONFIG from '@/config/collect.config'
import { TASK_RATE_TYPE } from '@/config/task.config'
import { GOOD_LIST } from '@/mock'

function CollectGoodsPage() {
  const router = useRouter()
  const [goodsList, setGoodsList] = useState([])
  const { item } = router?.params
  const { itemIds, todayCompleteTimes = 0, rateType, times, completeTimes = 0 } = JSON.parse(item)
  // 加购状态
  const initCompleteTimes = rateType === TASK_RATE_TYPE.EVERYDAY? +(todayCompleteTimes || completeTimes) : +completeTimes
  const collectFlag = useRef(initCompleteTimes)

  useEffect(() => {
    getGoodsList()
  }, [])
  const getGoodsList = async () => {
    const { data } = await API.getCollectGoods({ key: COLLECT_CONFIG.taskType, itemIds, taskType: COLLECT_CONFIG.taskType })
    data?.list && setGoodsList(data?.list || [])
  }

  const onCompleteTask = useThrottle(async(itemId,collected) => {
    const collectFn = async () => {
      const { success } = await API.completeTask({ key: COLLECT_CONFIG.taskType, itemId, taskType: COLLECT_CONFIG.taskType })
      if (success) {
        collectFlag.current += 1
        getGoodsList()
        showToast({ title: '收藏成功'})
      }
    }
    // 今日是否已收藏过
    if(rateType !== TASK_RATE_TYPE.FOREVER && collectFlag.current >= times) {
      showToast({title: '任务已完成，请明日再来'})
        return;
    }
    if (collected) {
      showToast({ title:'您已收藏过该商品了'})
        return;
    }
    // 判断是否活动外已收藏商品
    const isCollected = await checkGoodsCollectedStatus(+itemId)
    if (String(isCollected) === 'true') {
        collectFn()
        return;
    }
    const result = await collectGoods(+itemId)
    if (result && result?.success) {
      collectFn()
      return;
    }
  })

  return (
    <ContainerFit bg={COLLECT_CONFIG.bg} fullScreenFit>
      <View className={styles['page-content__title']} style={{}}>
        <TitleImg config={COLLECT_CONFIG.head} position={'bottom'} />
      </View>
      <View className={styles['page-content__list']}>
        <GoodsList goodsList={goodsList} task={COLLECT_CONFIG} onCompleteTask={(itemId,collected) => onCompleteTask(itemId,collected)} />
      </View>
    </ContainerFit>
  )
}

export default CollectGoodsPage
