/** @format */

import { services, preCheck, registeInfos, preUpdate, checkParams } from '../decorator/common/'
import { resultsModel } from '../sdk'
import { CommonSignService } from '../service/common'
import { STAT_TYPE } from '../constants'
import { checkActivityTime, checkInviteId, checkHelpRecord, checkNewVip, checkSign } from '../utils/common/check'
import { updateHelpRecord, updateVip } from '../utils/common/update/'

export default class SignController {
  /**
   *  签到
   */
  @checkParams(['activityId', 'subscribeSignDay?'])
  @services([CommonSignService])
  @preCheck([checkSign])
  async doSign(
    context: IContext<{
      activityId: string
      subscribeSignDay?: string
    }>,
    { userInfo }: IControllerInfos,
    [signService]: [CommonSignService]
  ) {
    const { activityId, subscribeSignDay } = context.data
    const result = await signService.doSign(userInfo, activityId, subscribeSignDay)
    return resultsModel.success(result)
  }
}
