import { findWinnerInfoList, getAwardsList, exportAwardsList } from '/api';
import moment from 'moment';

Component({
  mixins: [],
  data: {
    // 搜索条件
    searchInfo: {
      pageNo: 1,
      pageSize: 10,
      <% for(var i = 0; i < winnersFilterData.length; ++i) {%>
      <%-`${winnersFilterData[i]}: ${winnersFilterData[i] == 'timeRange' ? '[]' : null},`%><% }%>
    },
    list: [],
    total: 0,
    isLoading: false,
    showShip: false,
    winactivityId: '',
  },
  props: {
    onClose: () => { },
    onShowExportDialog: () => { },
    selectedItem: {}
  },
  didMount() {
    // this.searchList();
  },
  methods: {
    // 更换页码时调用接口
    handleChangePage(e) {
      const { value } = e.detail;
      this.setData({
        'searchInfo.pageNo': value
      });
      this.searchList();
    },
    // 搜索
    async handleSearch() {
      // 未选择任何条件搜索
      const {
        <% for(var i = 0; i < winnersFilterData.length; ++i) {%>
        <%- `${winnersFilterData[i]},`%><% } %>
      } = this.data.searchInfo;
      
      if (
        <% for(var i = 0; i < winnersFilterData.length; ++i) {%>
        <%- `${winnersFilterData[i] == 'timeRange' ?  `!${winnersFilterData[i]}.length` : `!${winnersFilterData[i]}`} ${i === winnersFilterData.length - 1 ? '' : '&&'}`  %>
        <% } %>
      ) {
        this.resetData();
        my.showToast({
          type: 'fail',
          content: '请填写至少一个筛选信息'
        });
        return;
      }
      this.setData({
        'searchInfo.pageNo': 1
      });
      this.searchList();
    },
    // start《条件搜索》初始化数据更新
    resetData() {
      this.setData({
        searchInfo: {
          pageNo: 1,
          pageSize: 10,
          <% for(var i = 0; i < winnersFilterData.length; ++i) {%>
          <%- `${winnersFilterData[i]}: ${winnersFilterData[i] == 'timeRange' ? '[]' : null},`  %><% } %>
        },
        list: [],
        total: 0,
        isLoading: false,
        showShip: false,
        winactivityId: ''
      });
    },
    onCloseDialog() {
      this.resetData();
      this.props.onClose && this.props.onClose();
    },

    // 监听input改变
    handleInputChange(e) {
      const { value } = e.detail;
      const { name } = e.target.dataset;
      this.setData({
        [`searchInfo.${name}`]: value
      });
    },
    // 监听发奖时间变化
    handleTimeRangeChange(e) {
      const [startTime, endTime] = e.detail.value;
      this.setData({
        'searchInfo.timeRange': [startTime, endTime]
      });
    },
    // 搜索
    async searchList() {
      let params = {
        ...this.data.searchInfo,
        activityId: this.props.selectedItem.activityId
      };
      <%- winnersFilterData.includes('timeRange') ?
      `params.startTime = new Date(params.timeRange[0]).getTime();
      params.endTime = new Date(params.timeRange[1]).getTime();
      delete params.timeRange;` : ''%>

      console.log('搜索参数', params);

      try {
        this.setData({
          isLoading: true
        });
        console.log(params);
        const { data, success } = (await findWinnerInfoList(params)) || {};
        const { list, total } = data;
        console.log(data, 'data-----');
        list.map(v => {
          v.createTime = moment(+v.createTime).format('YYYY-MM-DD HH:mm:ss');
          v.receiveTime = moment(+v.receiveTime).format('YYYY-MM-DD HH:mm:ss');
        });
        if (success) {
          this.setData({
            list,
            total
          });
          this.setData({
            isLoading: false
          });
        }
      } catch (error) {
        this.setData({
          isLoading: false
        });
      }
    },

    async handleExport(evt) {
      console.log(this.props);
      // 未选择任何条件搜索
      const {
        <% for(var i = 0; i < winnersFilterData.length; ++i) {%>
        <%- `${winnersFilterData[i]},`%><% } %>
      } = this.data.searchInfo;
      
      if (
        <% for(var i = 0; i < winnersFilterData.length; ++i) {%>
        <%- `${winnersFilterData[i] == 'timeRange' ?  `!${winnersFilterData[i]}.length` : `!${winnersFilterData[i]}`} ${i === winnersFilterData.length - 1 ? '' : '&&'}`  %>
        <% } %>
      ) {
        this.resetData();
        my.showToast({
          type: 'fail',
          content: '请填写至少一个筛选信息'
        });
        return;
      }
      const { activityId, title } = this.props.selectedItem;
      let params = { ...this.data.searchInfo, activityId, title };
      <%- winnersFilterData.includes('timeRange') ?
      `params.startTime = new Date(params.timeRange[0]).getTime();
      params.endTime = new Date(params.timeRange[1]).getTime();` : '' %>
      
      params.pageNo = 1;
      params.pageSize = 500;
      let res = [];
      delete params.timeRange;
      my.showLoading({
        content: '生成文件中...'
      });
      try {
          let { success, data, message } = (await exportAwardsList({ title, ...params })) || {};
          console.log(success, data, message, '复制链接');
          if (success) {
            this.props.onShowExportDialog({
              exportLinkUrl: data.url.replace(/amp;/g, '')
            });
            console.log(data, '下载链接');
          } else {
            my.showToast({
              type: 'fail',
              content: message
            });
          }

        my.hideLoading();
      } catch (error) {
        my.hideLoading();
        console.log(error, 'exportList-error');
      }
    },
    // 导入发货信息
    handleImport() {
      const { activityId } = this.props.selectedItem;
      console.log('打开导入文件弹窗');
      this.setData({
        showShip: true,
        winactivityId: activityId
      });
      console.log('winner====showShip', this.data.showShip);
    },
    // 关闭导入发货窗口
    handleShipClose() {
      this.setData({
        showShip: false,
        winactivityId: ''
      });
    }
  }
});
