/** @format */
import { getToday } from '../getToday'

// login接口使用 当天第一次登陆有数据变更的时候使用
// updateFirstLoginToday({ $inc: { gameTime: 3}})
export default function updateFirstLoginToday(update?: IPreUpdateQuery) {
  return async function (
    context: IContext<IParams>,
    { userInfo }: IControllerInfos
  ): Promise<IPreUpdateQuery | undefined> {
    if (!userInfo) return {}
    const firstLogin = userInfo?.login?.[`${getToday()}`] === 1

    return firstLogin ? update : {}
  }
}
