/** @format */

const fs = require('fs-extra')
const config = require('./config.json')
const { getDecorators, getPreChecks, getPreUpdates } = require('./utils/formatConfg')

const serverTemplatePath = 'templates'

const controllerImport = (controller = {}) => {
  const result = {
    services: {}
  }
  for (let fn in controller) {
    for (let main of controller[fn].main) {
      if (!result.services[main.type]) {
        result.services[main.type] = {}
      }
      result.services[main.type][main.service] = true
    }
  }
  return result
}

const customFileMap = (controllers = {}) => {
  const result = {
    decorators: {},
    utils: {},
    services: {}
  }
  for (let controllerType in controllers) {
    for (let controller in controllers[controllerType]) {
      for (let fn in controllers[controllerType][controller]) {
        for (let decorator of controllers[controllerType][controller][fn].decorators) {
          if (decorator.type === 'custom') {
            result.decorators[decorator.name] = true
          }
          for (let util of decorator.params || []) {
            if (util.type && util.type === 'custom') {
              result.utils[util.name] = true
            }
          }
        }
        for (let main of controllers[controllerType][controller][fn].main) {
          if (main.type === 'custom') {
            if (!result.services[main.service]) {
              result.services[main.service] = {}
            }
            result.services[main.service][main.function] = main.params
          }
        }
      }
    }
  }
  return result
}

const run = async (gulp, nunjucksRender, rename, nunjucksRenderConfig) => {
  //编译自定义文件
  const { decorators, utils, services } = customFileMap(config.controllers)
  for (let decorator in decorators) {
    await gulp
      .src(`${serverTemplatePath}/decorator.njk`)
      .pipe(
        nunjucksRender({
          ...nunjucksRenderConfig,
          data: {
            name: decorator
          }
        })
      )
      .pipe(rename(`${decorator}.ts`))
      .pipe(gulp.dest(nunjucksRenderConfig.ServerFullPath + '/decorator/custom'))
  }
  await gulp
    .src(`${serverTemplatePath}/decorator.export.njk`)
    .pipe(
      nunjucksRender({
        ...nunjucksRenderConfig,
        data: {
          decorators
        }
      })
    )
    .pipe(rename(`index.ts`))
    .pipe(gulp.dest(nunjucksRenderConfig.ServerFullPath + '/decorator/custom'))
  for (let util in utils) {
    await gulp
      .src(`${serverTemplatePath}/util.njk`)
      .pipe(
        nunjucksRender({
          ...nunjucksRenderConfig,
          data: {
            name: util
          }
        })
      )
      .pipe(rename(`${util}.ts`))
      .pipe(gulp.dest(nunjucksRenderConfig.ServerFullPath + '/utils/custom'))
  }
  await gulp
    .src(`${serverTemplatePath}/util.export.njk`)
    .pipe(
      nunjucksRender({
        ...nunjucksRenderConfig,
        data: {
          utils
        }
      })
    )
    .pipe(rename(`index.ts`))
    .pipe(gulp.dest(nunjucksRenderConfig.ServerFullPath + '/utils/custom'))
  for (let service in services) {
    await gulp
      .src(`${serverTemplatePath}/service.njk`)
      .pipe(
        nunjucksRender({
          ...nunjucksRenderConfig,
          data: {
            name: service,
            fns: services[service]
          }
        })
      )
      .pipe(rename(`${service}.service.ts`))
      .pipe(gulp.dest(nunjucksRenderConfig.ServerFullPath + '/service/custom'))
  }
  await gulp
    .src(`${serverTemplatePath}/service.export.njk`)
    .pipe(
      nunjucksRender({
        ...nunjucksRenderConfig,
        data: {
          services
        }
      })
    )
    .pipe(rename(`index.ts`))
    .pipe(gulp.dest(nunjucksRenderConfig.ServerFullPath + '/service/custom'))
  //编译controller.common

  for (let commonController in config.controllers.common) {
    const controller = config.controllers.common[commonController]
    await gulp
      .src(`${serverTemplatePath}/controller.njk`)
      .pipe(
        nunjucksRender({
          ...nunjucksRenderConfig,
          data: {
            name: commonController,
            model: controller,
            ...controllerImport(controller),
            commmonDecorators: getDecorators(controller, 'common'),
            customDecorators: getDecorators(controller, 'custom'),
            commonPreChecks: getPreChecks(controller, 'common'),
            customPreChecks: getPreChecks(controller, 'custom'),
            commonPreUpdates: getPreUpdates(controller, 'common'),
            customPreUpdates: getPreUpdates(controller, 'custom')
          }
        })
      )
      .pipe(rename(`${commonController}.controller.ts`))
      .pipe(gulp.dest(nunjucksRenderConfig.ServerFullPath + '/controller/common'))
  }
  //编译controller.custom
  for (let customController in config.controllers.custom) {
    const controller = config.controllers.custom[customController]
    await gulp
      .src(`${serverTemplatePath}/controller.njk`)
      .pipe(
        nunjucksRender({
          ...nunjucksRenderConfig,
          data: {
            name: customController,
            model: controller,
            ...controllerImport(controller),
            commmonDecorators: getDecorators(controller, 'common'),
            customDecorators: getDecorators(controller, 'custom'),
            commonPreChecks: getPreChecks(controller, 'common'),
            customPreChecks: getPreChecks(controller, 'custom'),
            commonPreUpdates: getPreUpdates(controller, 'common'),
            customPreUpdates: getPreUpdates(controller, 'custom')
          }
        })
      )
      .pipe(rename(`${customController}.controller.ts`))
      .pipe(gulp.dest(nunjucksRenderConfig.ServerFullPath + '/controller/custom'))
  }
  //接口导出
  await gulp
    .src(`${serverTemplatePath}/controller.export.njk`)
    .pipe(
      nunjucksRender({
        ...nunjucksRenderConfig,
        data: {
          controllers: config.controllers
        }
      })
    )
    .pipe(rename(`index.ts`))
    .pipe(gulp.dest(nunjucksRenderConfig.ServerFullPath))
  //编译constants.njk
  await gulp
    .src(`${serverTemplatePath}/constants.njk`)
    .pipe(
      nunjucksRender({
        ...nunjucksRenderConfig,
        data: {
          appId: config.appId
        }
      })
    )
    .pipe(rename(`constants.ts`))
    .pipe(gulp.dest(nunjucksRenderConfig.ServerFullPath))
}

module.exports = {
  run
}
