import tbccTs from 'tbcc-sdk-ts'
import API from '@/api'
const { getUserAddress, commonToast } = tbccTs.tb

export const noopFn = () => { }
// 领取实物
const getUerAddressParam = async () => {
    const userAddress = await getUserAddress().catch(err => {
        commonToast(err.errorMessage);
    });
    if(!userAddress) return false
    const { name, telNumber, provinceName, cityName, cityCode, countyName, detailInfo, streetName } = userAddress || {};
    const params = {
        name,
        phone: telNumber,
        addressDetail: detailInfo,
        cityCode,
        city: cityName,
        province: provinceName,
        area: countyName,
        streetName,
    }
    return {
        params,
        duibaAddress: userAddress.duibaAddress.address
    }
}
const confirmAddress = async (address) => {
    return new Promise(async (resolve,reject) => {
        my.confirm({
            title: '提示',
            content: '确认使用该收货地址：' + address,
            success: (res) => {
                if(res.confirm) {
                    resolve(true)
                }else {
                    resolve(false)
                }
            },
        });
    })
}
export const receiveObjectPrize = async (data) => {
    const { params, successMsg, errorMsg } = data
    return new Promise(async (resolve,reject) => {
        const userInfo = await getUerAddressParam()
        if(!userInfo) {
            resolve(false)
            return;
        }
        const { params: _params, duibaAddress } = userInfo
        const { name, phone } = _params
        const address = name + phone + duibaAddress
        const canPass = await confirmAddress(address)
        if(!canPass) {
            resolve(false)
            return;
        }
        const { success, data, message } = await API.receiveObjectPrize({ ...params, ..._params })
        if (success) {
            commonToast(successMsg)
            resolve(true)
        }else {
            commonToast(errorMsg || message)
            resolve(false)
        }
    })
}
// 领取权益
export const receiveEnamePrize = async (data) => {
    const { params, successMsg, errorMsg } = data
    return new Promise(async (resolve,reject) => {
        const { success, data, message } = await API.receiveEnamePrize(params).catch(res => {
            commonToast(successMsg || res.message)
            resolve(false)
        });
        if (success) {
            commonToast(successMsg)
            resolve(true)
        }else {
            commonToast(errorMsg || message)
            resolve(false)
        }
    })
}
// 领取会员优惠券
const applyActivity = (sellerId, activityId) => {
    const memberBenefitPlugin = requirePlugin("memberBenefit")
    if(!memberBenefitPlugin) return false
    return new Promise(async (resolve,reject) => {
        memberBenefitPlugin.applyActivity({
            data: {     
              sellerId,
              activityId,
            },
            success: (result) => {
                resolve(result)
            },
            fail: (error) => {
                console.warn('领取商家权益失败'+JSON.stringify(error.data))
                resolve(error.data)
            }
          });
    })
}
export const receiveMemberEname = async(data) => {
    const { params, successMsg, errorMsg } = data
    const { sellerId, ename, ...ext } = params
    if(!ename) return false
    return new Promise(async (resolve,reject) => {
        const result = await applyActivity(sellerId,ename)
        if(!result) resolve(false)
        if(result.businessSuccess) {
            const { success, data, message } = await API.updateEnamePrizeReceived({ ...ext })
            if(success) {
                commonToast(successMsg || '奖品发放成功，请前往我的奖品处进行使用')
                resolve(true)
            }else {
                commonToast(errorMsg || message)
                resolve(false)
            }
        }else{
            commonToast(result.errorMsg)
            resolve(false)
        }
    })
}
//打点
export const addStat = async(activityId, type)=> {
    return new Promise(async (resolve,reject) => {
        const result = await API.addStat({ activityId, type }).catch(res => {
            commonToast(res && res.message);
        });
        if (result && result.success) {
            resolve(true)
        }
        resolve(false)
    })
}
export const createCanvas = async (canvasId) => {
    return new Promise((resolve,reject) => {
        my.createCanvas({
            id: canvasId,
            success: (ccc) => {
                resolve(ccc)
            }
        })
    })
}
// 查询商家权益活动
export const getActivity = (sellerId) => {
    const memberBenefitPlugin = requirePlugin("memberBenefit")
    if(!memberBenefitPlugin) return []
    return new Promise(async (resolve,reject) => {
        memberBenefitPlugin.getActivity({
            data: {     
              sellerId,
            },
            success: (result) => {
                resolve(result)
            },
            fail: (error) => {
                console.log('获取失败'+JSON.stringify(error))
                resolve(error)
            }
          });
    })
}
// 查询商家会员等级
export const getGrade = (sellerId) => {
    const memberBenefitPlugin = requirePlugin("memberBenefit")
    if(!memberBenefitPlugin) return []
    return new Promise(async (resolve,reject) => {
        memberBenefitPlugin.getGrade({
            data: {     
              sellerId
            },
            success: (result) => {
                resolve(result)
            },
            fail: (error) => {
                console.log('查询商家会员等级失败'+JSON.stringify(error))
                resolve(error)
            }
          });
    })
}

let bgs = {
}
export const playBgMusic1 = async (isOn, src, loop=false) => {//待测试

	for (let k in bgs) {
		if (bgs[k].isOn) {
			bgs[k].stop();
		}
		// bgs[k].isOn = false;	/// TODO 自己记一个开关，因为淘宝的玩意stop之后虽然听不到，但还是在播放，会触发loop播放和onEnded事件
	}

	const key = src;
  console.log('---------->>>>>>>>>>>>>ison',isOn);
	if (isOn) {
		if (!bgs[key]) {
			bgs[key] = createAudio({
				src: src,
				autoplay: true,
				loop: loop /// TODO 暂时无效？2020.08.12 目前有效，但stop后还会跑数据，导致到音频结束到时间又自动播放
			});

      console.log('----------------src',src,bgs[key],'bgs[key]')

			bgs[key].onPlay(() => {
				bgs[key].isOn = true;
			});

			bgs[key].onStop(() => {
				bgs[key].isOn = false;
			});

      const systemInfo = await getSystemInfo();

      console.log(systemInfo,'systemInfo-------systemInfo')

			/// TODO监听结束，因为loop无效  2020.08.12 loop有效，这个操作是为了解决stop之后还会跑音频数据的问题
			bgs[key].onEnded(() => {
				if (bgs[key].isOn) {
          	// 判断自己记录的开关
            if(systemInfo?.platform.includes('Android')){
              // 安卓
              bgs[key].play();
            } else if(systemInfo?.platform.includes('iOS') || systemInfo?.platform.includes('iPhone OS ')){
              // ios
              bgs[key].isOn = false;
            }
            delete bgs[key];

				}
			});

			bgs[key].play();	// 安卓有时候autoplay好像莫得用

			// console.log(src)
			// bgs[key].isOn = true;	/// TODO 自己记一个开关，因为淘宝的玩意stop之后虽然听不到，但还是在播放，会触发loop播放和onEnded事件

		} else {

			bgs[key].play();
			// bgs[key].isOn = true;	/// TODO 自己记一个开关，因为淘宝的玩意stop之后虽然听不到，但还是在播放，会触发loop播放和onEnded事件
		}
	} else {
		if (bgs[key]) {
			// bgs[key].pause();	/// pause 垃圾，不能用
      console.log('test stop function is work or not')
			bgs[key].stop();
			// bgs[key].isOn = false;	/// TODO 自己记一个开关，因为淘宝的玩意stop之后虽然听不到，但还是在播放，会触发loop播放和onEnded事件
		}
	}
}