import React, { useEffect, useState } from 'react'
import { View } from '@tarojs/components'
import GoodsTitle from '@/components/_tb_comps/GoodsTitle/GoodsTitle'
import GoodsList from '@/components/_tb_comps/GoodsList/GoodsList'
import { useRequest } from '@/hooks/useRequest'
import { useRouter } from '@tarojs/taro'
import API from '@/api'
import styles from './orderGoods.module.less'

const orderConfig = {
  taskType: 'orderGoods',
  type: '01',
  bg: '//yun.dui88.com/taobaomini/clientCTest/goods_bg@2x.png',
  head: {
    image: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_title@2x.png',
    width: 750,// 头部banner/title 宽度
    height: 120,// 头部banner/title 高度
  },
  image: {
    banner: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_banner@2x.png',
    title: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_title@2x.png',
    collect: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_collection@2x.png',
    no_collect: '//yun.duiba.com.cn/taobaomini/clientCTest/collection_no_collect@2x.png',
    img: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_img@2x.png'
  },
  color: '#181818'
}

function OrderGoodsPage() {
  const router = useRouter()
  const { itemIds } = router?.params
  const { data } = useRequest(API.getItemListByItemIds, { itemIds })

  return (
    <View className={styles['page-container']}>
      <View className={styles['page-psd-container']} style={{ background: `url(${orderConfig.bg}) no-repeat`, backgroundSize: '750rpx 1624rpx' }}>
        <View className={styles['page-content']}>
          <View className={styles['page-content__title']}>
            <GoodsTitle config={orderConfig.head}/>
          </View>
          <View className={styles['page-content__list']}>
            <GoodsList goodsList={data?.list || []} task={orderConfig} onOpenDetail={(itemId,isBrowsed) => onOpenDetail(itemId,isBrowsed)} />
          </View>
        </View>
      </View>
    </View>
  )
}

export default OrderGoodsPage
