/**
 * @description 音乐
 */
 import React, { useState, useEffect } from "react";
 import { playBgMusic1 } from "@/utils/util";
 const app = getApp();
 
 /**
  * @description 一个页面不能同时create两个音频文件
  * @param {*} url cloud文件链接
  * @param {*} isBgMusic 是否自动调用(背景音乐自动调用),非背景音乐(点击音效)手动调用
  * @returns 
  */
 export const useAudio = (url, isBgMusic) => {
   const [musicUrl, setMusicUrl] = useState();
   const [openStatus,setOpenStatus] = useState(true);
   useEffect(() => {
     getMusicInfo();
   }, []);

   useEffect(()=>{
    if(isBgMusic){
        console.log('enter use audio function with bg music');
        playAudio();
    }
   },[musicUrl,openStatus])

   /**
    * @description 获取音频url链接
    */
   const getMusicInfo = async () => {
     const resultSrc = await app.cloud.file.getTempFileURL({ fileId: url });
     console.log('resultSrc--------hook',resultSrc);
     if (resultSrc[0]){
       setMusicUrl(resultSrc[0].url);
     } 
   };
   /**
    * @description 播放音效
    * @param {*} selfStatus 是否单独控制音效状态
    */
   const playAudio = (selfStatus = false) => {
     console.log('musicUrl',musicUrl,'selfStatus',selfStatus)
     if(!selfStatus){
       selfStatus = openStatus
     }
     if(!musicUrl){
       return
     } else {
       musicUrl && playBgMusic1(selfStatus, musicUrl, false);
     }
   };
   return {
     playAudio,
     openStatus,
     setOpenStatus,
     musicUrl
   };
 };

 
