// 分享配置
export const SHARE_CONFIG = {
  title: '分享测试标题',
  desc: '分享测试描述',
  imageUrl: '' // 分享图片URL
}

// 领取奖品状态
export const DRAW_STATUS = {
  // 待领取
  WAITAWARD: 1,
  // 处理中
  PROCESSING: 2,
  // 领取成功
  SUCCESS: 3,
  // 领取失败
  FAIL: 4,
  // 已过期
  EXPIRED: 5,
  // 重新领取
  RETRY: 6
}

// 奖品类型
export const PRIZE_TYPE = {
  ENAME: 1,
  CREDITS: 2,
  OBJECT: 3,
  THANKS: 5
}

// 我的奖品状态
export const PRIZE_DRAW_STATUS_MAP = {
  RECEIVE: 1, // 待领取
  DEALING: 2, // 处理中
  SUCCESS: 3, // 领取成功
  FAILURE: 4, // 领取失败
  FINISHED: 5, // 已过期
  REPEAT: 6 // 重新领取
}
// 奖品类型
export const PRIZE_TYPE_MAP = {
  EQUITY: 1, // 权益
  INTEGRATION: 2, // 积分
  ENTITY: 3, // 实物
  THANKS: 5 // 谢谢参与
}

// 活动状态
export const ACTIVITY_STATUS = {
  NO_EXIST: 0, // 不存在
  PROCESSING: 1, // 正在进行
  NO_START: 2, // 未开始
  END: 3 // 已经结束
}

// 任务频率类型常量
export const TASK_RATE_TYPE = {
  FOREVER: 1,
  EVERYDAY: 2,
  NOLIMIT: 3
}

// 任务状态
export const TASK_STATUS = {
  WAIT_DO: 1, // 未完成
  WAIT_RECEIVE: 2, // 待领取
  DONE: 3 // 已完成
}

export const TASK_CONFIG = {
  taskIcon: { // 任务图标
    follow: '//yun.duiba.com.cn/baicaoweiFarmer/follow.png',
    member: '//yun.duiba.com.cn/baicaoweiFarmer/memberStar1.png',
    invites: '//yun.duiba.com.cn/baicaoweiFarmer/invites.png',
    jumpLink: '//yun.duiba.com.cn/baicaoweiFarmer/browseGoodsLink.png',
    browseGoods: '//yun.duiba.com.cn/baicaoweiFarmer/browseGoods.png',
    orderGoods: '//yun.duiba.com.cn/baicaoweiFarmer/orderGoods.png',
    collectGoods: '//yun.duiba.com.cn/baicaoweiFarmer/orderGoods.png',
    sign: '//yun.duiba.com.cn/baicaoweiFarmer/orderGoods.png',
    exchangeCredits: '//yun.duiba.com.cn/baicaoweiFarmer/orderGoods.png'
  },
  commonTaskTxt: {
    1: '去完成',
    2: '待领取',
    3: '已完成'
  },
  doTaskTxt: {
    follow: '立即关注',
    invites: '去邀请',
    member: '1秒入会',
    sign: '立即签到',
    jumpLink: '去完成',
    browseGoods: '去完成',
    orderGoods: '去完成',
    collectGoods: '去完成'
  },
  jumpLinkType: 1, // 1 跳转浏览15s 才算完成   2  跳转即算完成
  browseTime: 15, // 浏览时间
  browseGoodType: 1,  // 1 浏览15s 才算完成 2 点击就算完成任务 3 浏览指定商品详情页 15s
  showTaskType: 1,// 1 弹窗 2 列表
  orderGoodType: 1, // 1 集合页下单 2 跳转店铺 
}
// 权益类型
export const BENEFIT_TYPE = {
  ENAME: 1,// 普通权益
  MEMBER: 2 // 会员权益
}
// 浏览商品类型
export const BROSE_GOOD_TYPE = {
  PAGE: 1, // 浏览集合页15s
  CLICK: 2, // 点击就算完成任务
  DETAIL: 3 // 浏览指定商品详情页15s
}
// 购买商品类型
export const ORDER_GOOD_TYPE = {
  PAGE: 1, // 集合页下单
  SHOP: 2, // 跳转店铺
}
// 店铺ID
export const SHOP_ID = '60014226'

// 助力弹窗类型
export const HELP_MODAL_TYPE = {
  HELP: 1, // 邀请助力
  FAIL: 2, // 助力失败
  REWARDS: 3, // 助力信息展示
}
// 助力弹窗是否已弹
export const HELP_MODAL_SHOW = {
  SHOW: 1, // 已弹
  NOT_SHOW: 2, // 未弹
}
/* 背景音乐 应用：牧场消消乐有效，其他应用需要重新上传文件 */
export const BGMUSIC_URL = {
  MUSIC:'cloud://FBE3C154661ACEEBA164E8B70B4D71E2/yoga bgm.mp3'
}
/* 点击音效 */
export const CLOUD_OBJ = {
  '1':'cloud://0BD38A1B739CCF6A552396F3FE2D5A09/开始-音效.mp3',
  '2':'cloud://93FBC274B6B43CE37B0A70DF8C1AFA52/答题-音效.mp3',
  '3':'cloud://B8F0BA22BBA74F8FEA261E1CC9D55355/欢呼声.mp3'
}

/* 测试数据mock */
export const prizeList = [
  {
    image:
      "https://yun.duiba.com.cn/spark/assets/240121a7e7e10a66ad0cfa99a8b3ba9631fc7855.png",
      name:'商品描述商品描述商品描述商品描述商品描述1',
      content:'商品描述商品描述商品描述商品描述商品描述1',
      hasBtn:true
  },
  {
    image:
      "https://yun.duiba.com.cn/spark/assets/f9160b053f525455503ea58ae6b43bacea400362.png",
      name:'商品描述商品描述商品描述商品描述商品描述2',
      content:'商品描述商品描述商品描述商品描述商品描述2'

  },
  {
    image:
      "https://yun.duiba.com.cn/spark/assets/28b868b5da81ebd28a4eb14291a8ac287937221c.png",
      name:'商品描述商品描述商品描述商品描述商品描述3',
      content:'商品描述商品描述商品描述商品描述商品描述3'
  },
  {
    image:
      "https://yun.duiba.com.cn/spark/assets/3c305fb907bbebb85ad392cb959fbe62200c407f.png",
      name:'商品描述商品描述商品描述商品描述商品描述4',
      content:'商品描述商品描述商品描述商品描述商品描述4'

  },
  {
    image:
      "https://yun.duiba.com.cn/spark/assets/28b868b5da81ebd28a4eb14291a8ac287937221c.png",
      name:'商品描述商品描述商品描述商品描述商品描述5',
      content:'商品描述商品描述商品描述商品描述商品描述5'
  },
  {
    image:
      "https://yun.duiba.com.cn/spark/assets/3c305fb907bbebb85ad392cb959fbe62200c407f.png",
      name:'商品描述商品描述商品描述商品描述商品描述6',
      content:'商品描述商品描述商品描述商品描述商品描述6'

  },
  {
    image:
      "https://yun.duiba.com.cn/spark/assets/554a90eee5a31ae7628950907974bdee2da8c01e.png",
      name:'商品描述商品描述商品描述商品描述商品描述7',
      content:'商品描述商品描述商品描述商品描述商品描述7'

  },
  {
    image:
      "https://yun.duiba.com.cn/spark/assets/554a90eee5a31ae7628950907974bdee2da8c01e.png",
      name:'商品描述商品描述商品描述商品描述商品描述8',
      content:'商品描述商品描述商品描述商品描述商品描述8'

  }
];