import React, { useState } from 'react'
import { View, Image, ScrollView } from '@tarojs/components'
import Taro, { useShareAppMessage, useDidShow } from '@tarojs/taro'
import classnames from 'classnames'
import styles from './ScrollXView.module.less'

function ScrollXView(props) {
    const { prizeList = [], marginRight = 26, width = 300, height = 300 } = props

    const showPrize = classnames(styles['show-pize-box'],{
        [`${styles['show-pize-box__two']}`]: prizeList.length === 1
    })
    return (
        <>
            <ScrollView scrollX className={styles['scroll-x-box']}>
                {<View className={showPrize} style={prizeList.length > 1?{width: (prizeList.length * width + (prizeList.length) * marginRight + 100) / 100 + 'rem'}: { width: '100%'}}>
                    {
                        prizeList.map(itm => {
                            return(
                                <View style={{ width: width / 100 +'rem',height: height / 100 +'rem'}} className={styles['show-pirze__item']}>
                                    <View className={styles['pirze__item-img']}>
                                        <Image src={itm.image} className={styles['pirze__item-img-icon']} />
                                    </View>
                                    <View className={styles['pirze__item-name']}>{itm.name}</View>
                                </View>
                            )
                        })
                    }
                </View>}
            </ScrollView>
        </>
    )


}

export default ScrollXView