import { Main } from './output';
/**
 * 直接取，app
 */
const app = getApp()
Component({
  isUpdateFlag: true,
  data: {
    needDataInCanvas: {}
  },
  didMount(query) {

  },
  didUpdate(preProps,preData) {
    // 实时监听数据更新
    const { updateFlag, netName, updateData } = this.props
    if(updateFlag !== 1 && updateFlag !== preProps.updateFlag) {
      // this.postMessage(netName, updateData)
      console.warn('数据更新了')
    }
  },
  methods: {
    onCanvasReady() {
      console.log("进canvas了")
      // 创建Main，授权登录完后才创建
      this.createMain();
    },
    //创建引入的Main
    createMain() {
      const self = this;
      my.createCanvas({
        id: 'canvas',
        success: (ccc) => {
          const dpr = my.getSystemInfoSync().pixelRatio
          const windowWidth = my.getSystemInfoSync().windowWidth;
          const windowHeight = my.getSystemInfoSync().windowHeight;
          ccc.width = windowWidth * dpr + dpr;//重新修改会有误差
          ccc.height = windowHeight * dpr + dpr;
          // console.log(Main)
          console.log(ccc.width, ccc.height)
          if (!this.main) {
            try {
              this.main = new Main(ccc)

              //添加事件，为了和main里的通信
              this.main.addGlobalEvent("onMessage", self.onMessage, self)
            } catch (err) {
              console.error(err)

            }
          }
        }
      })
    },
    //和main通信的方法，接收main的信息
    onMessage(e) {
      //接口名字
      let netName = e.data.netName;
      //接口参数
      let parameter = e.data.parameter;
      //暂时发现3个需要用户操作的接口
      //定制的授权
      if (netName == "mine.authorize") {
        this.getAuth()
      }
      //获取地址
      else if (netName == "mine.getUserAddress") {
        this.getUserAddress(parameter.prizeId)
      }
      //关注店铺的操作
      else if (netName == "mine.favorShop") {
        this.doFavorShop()
      }
      //领养名字，有弹框的
      else if (netName == "mine.getAdoptName") {
        this.setData({ "adoptModalVisible": true, type: parameter.type })
      }
      //打开详情页，还有成功失败
      else if (netName == "mine.openDetail") {
        openDetail(parameter.itemId).then(
          () => {
            this.postMessage(netName, { success: true })
          },
          () => {
            this.postMessage(netName, { success: false })
          }
        )
      }
      //前端同步接口
      else if (netName.indexOf("mine") == 0) {
        var data = { success: true }
        switch (netName) {
          case "mine.getAppData"://获取信息
            data = {
              success: true,
              data: {
                activityId: app.activityId,//|| "5e7c40e98564b57d7fb95812",
                nickName: app.nickName,
                avatar: app.avatar,
                openId: app.openId,
                inviteId: this.inviteId,//判断是否要发助力用
                isFollow: app.isFollow,
                needDataInCanvas:app.needDataInCanvas,
                activityInfo:this.activityInfo,
                userInfo:this.userInfo,

                newUser: this.newUser,
                remainTimes: this.remainTimes,
                firstLoginToday: this.firstLoginToday,
              }
            }
            break;
          case "mine.navigateToOutside"://跳转小程序外的页面
            my.call("navigateToOutside", {
              url: parameter.url
            }, (res) => {
              // my.alert({ content: "success - " + JSON.stringify(res)})
            })
            console.log(parameter.url)
            break;
          case "mine.navigateTo"://跳转小程序内的页面
            my.navigateTo({
              url: parameter.url
            })
            break;
          case "mine.navigateBack"://返回页面
            my.navigateBack({
              delta: parameter.delta || 1
            })
            break;
          case "mine.showSharePanel"://分享
            //多一个参数
            this.openId = parameter.openId;
            my.showSharePanel()
            break;
          case "mine.reportAnalytics":  ////淘宝自定义埋点
            reportAnalytics(parameter.logkey);
            break;
          case "mine.openMusic":  //音频
            playBgMusic(parameter.isOn, this.musicUrl);
            break;

          case "mine.openTask":  //打开任务
            this.setData({ taskModalVisible: true });
            break;

          case "mine.openMember":  //打开入会
            this.setData({ expend: true, });
            break;
        }
        this.postMessage(netName, data)
      } else {
        //获取后端接口
        const { function: fc } = app.cloud;
        //处理下带上activityId
        if (!parameter) parameter = {};
        parameter.activityId = app.activityId;
        //netName得分割下
        fc.invoke(netName.split(".")[0], parameter, netName.split(".")[1])
          .then(res => {
            // console.log("返回数据" + JSON.stringify(res));
            //发送消息
            this.postMessage(netName, res || { success: false })
          }, (err) => {
            //网络异常，返回失败
            this.postMessage(netName, { success: false })
          })
      }
    },
    //和main通信的方法，接收main的信息
    onMessage2(e) {
      // this.props.onPostMessage({
      //   type: 'postMessage',
      //   target: {
      //     id: this.props.id
      //   },
      //   data: e.data
      // })
    },
    postMessage(netName, data) {
      // this.main.dispatchGlobalEvent(netName, data)
      this.main && this.main.dispatchGlobalEvent({ type: netName }, data)//以防复用事件event串了，就用这种方式
    },
    //鼠标事件
    onMouseEvent(e) {
      if (this.main) this.main.stage.onMouseEvent(e)
    },
    // 发送数据
    onPostMessage() {
      this.props.onPostMessage({
        type: 'postMessage',
        target: {
          id: this.props.id
        },
        data: {
          a: 222,
          b: 33
        }
      })
    }
  }
});
