/** @format */
import { resultsModel } from '../sdk'
import { CODE_TYPES } from '../constants'
export const paramsCheck = (params: string[]) => {
  return function (target: Object, name: string, descriptor: PropertyDescriptor) {
    const method = descriptor.value

    descriptor.value = function (...args: any[]) {
      const [context, otherArgs = {}] = args
      const dataKeys = Object.keys(context.data)
      for (let i = 0; i < params.length; i++) {
        const param = params[i]
        if (!dataKeys.includes(param)) return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `缺少${param}参数`)
      }
      return method.apply(target, [context, { ...otherArgs }])
    }
  }
}
