
const app = getApp();
const { tbcc } = app;
const { commonToast, navigateToOutside, getUserAddress, setClipboard } = tbcc.tb;
const { PRIZE_TYPE_MAP, PRIZE_DRAW_STATUS_MAP } = tbcc.constants;
Component({
  mixins: [],
  data: {
    PRIZE_TYPE_MAP,
    PRIZE_DRAW_STATUS_MAP,
    currentPrize: {},
    isLogistic: false,
  },
  props: {
    myPrizeList: null, //我的奖品
    endTime: null,//到期时间
    task: {
      image: {},
      logisticsImage: {},
      btnStyle: {}
    }
  },
  didMount() { },
  didUpdate() { },
  didUnmount() { },
  methods: {
    //领取奖品
    handleClick(e) {
      this.props.onHandleClick(e)
    },
    // 复制编码
    handleCopyId(e) {
      const { text } = e.target.dataset || {}
      setClipboard({ text })
      console.log(text)
      commonToast('复制成功')
    },
    // 去使用
    handleTouse(e) {
      const { item } = e.target.dataset;
      navigateToOutside(item.useUrl)
    },
    //查看物流
    handleView(e) {
      let { item } = e.target.dataset
      this.setData({ currentPrize: item, isLogistic: true })
    },
    /**
    * 关闭物流弹窗
    */
    closeLogisticModal() {
      this.setData({ isLogistic: false })
    },
  },
});
