/**
 * 任务类型（taskType）:collectGoods、orderGoods、browseGoods、
 */
const app = getApp();
const { tbcc } = app;
const { openDetail, collectGoods, checkGoodsCollectedStatus } = tbcc.tb;

Component({
  mixins: [],
  timer: null,
  data: {
    usePercent: 0, // 已进行的进度条
    percent: 0,// 进度条
    isShowCountdown: true, // 是否显示倒计时
    isFlag: 1
  },
  props: {
    isBackFlag: 0,
    goodsList: [1,2,3],
    task: {
      itemId: '617724147979,617724563528,617300295119,614139753189',
      taskType: 'browseGoods',
      type: '02',
      bannerHeight: 430,
      image: {
        bg: '//yun.dui88.com/taobaomini/clientCTest/goods_bg@2x.png',
        banner: '//yun.dui88.com/taobaomini/clientCTest/goods_banner@2x.png',
        title: '//yun.dui88.com/taobaomini/clientCTest/goods_title@2x.png',
        collect: '//yun.dui88.com/taobaomini/clientCTest/goods_collection@2x.png',
        no_collect: '//yun.dui88.com/taobaomini/clientCTest/collection_no_collect@2x.png',
        img: '//yun.dui88.com/taobaomini/clientCTest/goods_img@2x.png',
      },
      color: '#181818'
    },
    onCompleteTask: () => {}
  },
  didMount() {
    const { taskType } = this.props.task
    this.setData({ isFlag: this.props.isBackFlag })
    console.log(this.props.goodsList)
    if(taskType == 'browseGoods') {
      this.browseGoodsTimes()
    }
  },
  didUpdate(prevProps,prevData) { 
    if(prevData.isFlag && prevProps.isBackFlag != prevData.isFlag) {
      console.log(3)
      if(!this.timer) {
        this.setData({ usePercent: this.data.percent })
        this.browseGoodsTimes()
        console.log(10 - this.usePercent)
      }
    }
  },
  didUnmount() {
    clearTimeout(this.timer)
  },
  methods: {
    /**
     * 跳转商品详情页
     */
    async goToGoodsDetail(e) {
      clearInterval(this.timer)
      this.setData({
        percent: this.data.usePercent,
      })

      const { itemId } = e.target.dataset.item
      await openDetail(String(itemId))
    },
    /**
     * 收藏商品
     */
    async goToCollectGoods(e) {
      const { itemId, collected } = e.target.dataset.item
      const { taskType } = this.props.task
      if(collected) return;
      let result = await collectGoods(itemId)
      if(result) {
        this.props.onCompleteTask(taskType, itemId)
      }
    },
    /**
     * 浏览商品倒计时
     */
    browseGoodsTimes() {
      const { taskType } = this.props.task

      this.timer = setInterval(() => {
        this.setData({
          usePercent: this.data.usePercent + 1
        }, () => {
          if (this.data.usePercent >= 10) {
            console.log(this.data.usePercent)
            this.props.onCompleteTask(taskType)
            clearInterval(this.timer)
          }
        })
      },1000)
    }
  },
});
