import React, { useState } from 'react'
import { View, Image, ScrollView } from '@tarojs/components'
import Taro, { useShareAppMessage, useDidShow } from '@tarojs/taro'
import classnames from 'classnames'
import styles from './ScrollXView.module.less'


function ScrollXView(props) {
    const { 
        prizeList = [], 
        containerWidth = 300, 
        containerHeight = 300,
        imgWidth=240,
        imgHeight=240,
        isShowPrizeName=true,
        prizeInCenterNum=2,
        marginRight=26,
        backgroundColor='#E7E7EF',
        backgroundImage=''
    } = props

    const showPrize = classnames(styles['show-pize-box'],{
        [`${styles['show-pize-box__two']}`]: prizeList.length <= prizeInCenterNum,
        [`${styles['show-pize-box__more']}`]: prizeList.length > prizeInCenterNum,
    })

    return (
        <>
            <ScrollView scrollX className={styles['scroll-x-box']}>
                {<View className={showPrize}>
                    {
                        prizeList.length > 0 && prizeList.map((itm,i) => {
                            return(
                                <View 
                                    key={'prize'+i}
                                    className={styles['show-pirze__item']} 
                                    style={{ 
                                        width:`${containerWidth/100}rem`,
                                        height:`${containerHeight/100}rem`,
                                        backgroundImage:`${backgroundImage}`,
                                        backgroundColor:backgroundColor,
                                        marginRight:`${((prizeList.length > prizeInCenterNum) &&(prizeList.length - 1) !== i) ? `${marginRight/100}rem` : ''}`
                                    }} 
                                >
                                    <View 
                                        className={styles['pirze__item-img']}
                                        style={{
                                            width:`${imgWidth/100}rem`,
                                            height:`${imgHeight/100}rem`
                                        }}
                                    >
                                        <Image 
                                            src={itm.image} 
                                            className={styles['pirze__item-img-icon']} 
                                            style={{
                                                width:`${imgWidth/100}rem`,
                                                height:`${imgHeight/100}rem`
                                            }}
                                        />
                                    </View>
                                    {
                                        isShowPrizeName &&
                                        <View 
                                            className={styles['pirze__item-name']}
                                            style={{
                                                height:`${60/100}rem`,
                                                fontSize:`${24/100}rem`
                                            }}
                                        >{itm.name}</View>
                                    }
                                </View>
                            )
                        })
                    }
                </View>}
            </ScrollView>
        </>
    )


}

export default ScrollXView