import React, { useState, useEffect } from 'react'
import { Image, ScrollView, View } from '@tarojs/components'
import API from '@/api'
import DeliveryModal from '@/components/_tb_modal/DeliveryModal/DeliveryModal'
import ContainerFit from '@/components/_base/ContainerFit/ContainerFit'
import TitleImg from '@/components/_tb_comps/TitleImg/TitleImg'
import tbccTs from 'tbcc-sdk-ts'
import { useThrottle } from '@/hooks/useThrottle'
import { checkIsMember } from 'tbcc-sdk-ts/lib/utils'
import { dateFormatter } from '@/utils/date'
import styles from './myPrize.module.less'
import { getApp } from '@tarojs/taro'
import { receiveEnamePrize, receiveObjectPrize, receiveMemberEname } from '@/utils/util'
import config from '@/config/config'
import { PRIZE_CONFIG, DRAW_STATUS, PRIZE_TYPE, BENEFIT_TYPE } from '@/config/myPrize.config'
const { objectStatus: _objectStatus, enameStatus: _enameStatus, orderStatus, commonStatus } = PRIZE_CONFIG
const objectStatus = { ..._objectStatus, ...commonStatus }
const enameStatus = { ..._enameStatus, ...commonStatus }

const { commonToast, navigateToOutside, setClipboard } = tbccTs.tb
const { getMyPrizeList } = API

function Empty(blankTxt) {
  return <View className={styles['my-prize-item__empty']}>{blankTxt}</View>
}

function MyPrizeList() {
  const app = getApp()
  const [ myPrizeList, setMyPrizeList ] = useState([])
  const [ expiredTime, setExpiredTime ] = useState('')
  const [ currentPrize, setCurrentPrize ] = useState({})
  const [ memberVisible, setMemberVisible ] = useState(false)
  const [ deliveryModalVisible, setDeliveryModalVisible ] = useState(false)

  useEffect(() => {
    fetchMyPriceList()
  }, [])
  async function fetchMyPriceList() {
    const res = await getMyPrizeList()
    if (res.success && res?.data?.list?.length) {
      setMyPrizeList(res?.data?.list)
    }
    if (res?.data?.expiredTime) {
      setExpiredTime(dateFormatter(res?.data?.expiredTime, 'yyyy/MM/dd hh:mm:ss'))
    }
  }
  // 复制编码
  const handleCopyId = async(text) => {
    await setClipboard(text)
    commonToast('复制成功')
  }
  // 领取奖品
  const handleClick = useThrottle(async (item) => {
      const { activityId } = app
      const { type, drawStatus, useUrl = '', id, _id, ename = '', benefitType } = item
      // 领取前验证
      if (drawStatus === DRAW_STATUS.SUCCESS) {
        if (type === PRIZE_TYPE.OBJECT && PRIZE_CONFIG.hasLogistic) {
          setCurrentPrize(item)
          setDeliveryModalVisible(true)
          return
        }
        if (type !== PRIZE_TYPE.OBJECT && useUrl) {
          navigateToOutside(useUrl)
          return
        }
      }
      if (!(drawStatus === DRAW_STATUS.RETRY || drawStatus === DRAW_STATUS.WAITAWARD)) {
        return
      }
      // 执行奖品领取
      const successMsg = '领取成功'
      if(type === PRIZE_TYPE.CREDITS || (type === PRIZE_TYPE.ENAME && benefitType === BENEFIT_TYPE.MEMBER)) {
        const isVip = await checkIsMember()
        if(!isVip) {
          commonToast('需加入会员才能领取成功哦', 2000, () => { setMemberVisible(true) })
          return;
        }
      }
      const receiveFn = {
        'update': async () => fetchMyPriceList(),
        [PRIZE_TYPE.ENAME]: async () => {
          if(benefitType === BENEFIT_TYPE.MEMBER) {
           await receiveMemberEname({params: { sellerId: config.sellerId, ename, id }, successMsg })
          }else {
            await receiveEnamePrize({params: { activityId, id }, successMsg })
          }
        },
        [PRIZE_TYPE.OBJECT]: async () => {
          await receiveObjectPrize({params: { activityId, id }, successMsg })
        },
        [PRIZE_TYPE.CREDITS]: async () => {
          await receiveEnamePrize({params: { activityId, id }, successMsg })
        }
      }
     await receiveFn[type]()
     receiveFn['update']()
  },2000)
  // 入会插件
  const onClose = () => {
    setMemberVisible(false)
  }
  const onAuthSuccess = () => {
    setMemberVisible(false)
  }
  const onAuthFail = () => {
    setMemberVisible(false)
  }

  return (
    <>
    <ContainerFit bg={PRIZE_CONFIG.bg}>
        <View className={styles['my-prize-label']}>
          <TitleImg config={PRIZE_CONFIG.head}></TitleImg>
        </View>
        <View className={styles['my-prize-content']} style={{ top: PRIZE_CONFIG.contentTop }}>
          <ScrollView scrollY className={styles['my-prize-content__scroll']}>
            {myPrizeList.length > 0 &&
              <View className={styles['my-prize-list']}>
                {myPrizeList.map((item, i) => {
                  return (
                    <View className={styles['my-prize-item']} key={'prize_'+i}>
                      <Image className={styles['my-prize-item__avatar']} src={item.image} />

                      <View className={styles['my-prize-item__content']}>
                        <View className={styles['my-prize-item__name']}>{item.name}</View>
                        {
                          PRIZE_CONFIG.isShowPirzeId &&
                            <View className={styles['my-prize-item__subtitle']}>
                              <View className={styles['my-prize-item__code']}>奖品编码：{item.id || item._id}</View>
                              {/* <!-- 复制按钮 --> */}
                              <Image className={styles['my-prize-item__copy']} onTap={() => handleCopyId(item.id || item._id)} src={PRIZE_CONFIG.copyIcon} />
                            </View>
                        }
                        {item.drawStatus === DRAW_STATUS.FAIL && <View className={styles['my-prize-item__tip']}>{item.remark}</View>}
                        {(item.drawStatus === DRAW_STATUS.RETRY || item.drawStatus === DRAW_STATUS.WAITAWARD) && <View className={styles['my-prize-item__tip']}>请于{expiredTime}前领取</View>}
                        {item.drawStatus === DRAW_STATUS.EXPIRED && <View className={styles['my-prize-item__tip']}>奖品已过期失效</View>}

                      </View>

                      <View className={styles['prize-item__status']} style={PRIZE_CONFIG.btnStyle}>
                        {item.type === PRIZE_TYPE.OBJECT
                          ? <Image onTap={() => handleClick(item)} src={objectStatus[item.drawStatus]} mode='widthFix' />
                          : <Image onTap={() => handleClick(item)} src={(item.drawStatus === 3 && !item.useUrl) ? PRIZE_CONFIG.receiveBtn : enameStatus[item.drawStatus]} mode='widthFix' />}
                      </View>
                    </View>
                  )
                })}
              </View>}
            {
              myPrizeList.length === 0 && Empty(PRIZE_CONFIG.blankTxt)
            }
          </ScrollView>
        </View>
    </ContainerFit>
      {deliveryModalVisible && <DeliveryModal prizeItem={currentPrize} task={PRIZE_CONFIG.logisticsImage} onClose={() => setDeliveryModalVisible(false)} />}
      {memberVisible && <member-modal onClose={onClose} onAuthFail={onAuthFail} onAuthSuccess={onAuthSuccess} />}
    </>
  )
}
export default MyPrizeList