import React, { useState } from 'react'
import { View, Image, ScrollView } from '@tarojs/components'
import classnames from 'classnames'
import tbccTs from 'tbcc-sdk-ts'
const { openDetail } = tbccTs.tb
import styles from './GoodsList.module.less'

function GoodsList(props) {
    const {
        goodsList = [],
        task = {
          itemId: '617724147979,617724563528,617300295119',
          taskType: 'browseGoods',
          image: {
            collect: '//yun.dui88.com/taobaomini/clientCTest/goods_collection@2x.png',
            no_collect: '//yun.dui88.com/taobaomini/clientCTest/collection_no_collect@2x.png',
            img: '//yun.dui88.com/taobaomini/clientCTest/goods_img@2x.png'
          },
          color: '#181818'
        },
        onOpenDetail,
        onCompleteTask
      } = props

    const goToGoodsDetail = async(item) => {
        const { taskType } = task
        const { itemId } = item
        if (taskType === 'browseGoods') {
          onOpenDetail && onOpenDetail(itemId)
        }
    
        await openDetail(String(itemId))
    }
    // 收藏商品
    const goToCollectGoods = async(item) => {
      const { itemId, collected } = item
      onCompleteTask && onCompleteTask(itemId,collected)
    }
    // 收藏按钮
    const getCollectStyle = (collected) => {
        return classnames(styles['item__price-collect'],{
            [`${styles['item__price-no-collect']}`]: collected
        })
    }
    return (
        <ScrollView scrollY className={styles['container__scroll']}>
          <View className={styles['container__content-list']}>
            {
              goodsList.map((item, i) => {
                return (
                  <View className={styles['content-item']} key={'goods_'+i}>
                    <View className={styles['item__img']} onClick={() => goToGoodsDetail(item)}>
                      <Image mode='scaleToFill' src={item.image} />
                    </View>
                    <View className={styles['item__name']} style={{ color: task.color }}>{item.name}</View>
                    <View className={styles['item__price']}>
                      <View className={styles['item__price-num']}><text>¥</text>{item.price}</View>
                      {
                        task.taskType === 'collectGoods' &&
                          <View
                            onClick={() => goToCollectGoods(item)}
                            className={() => getCollectStyle(item.collected)}
                          >
                            <Image mode='scaleToFill' src={item.collected ? task.image.collect : task.image.no_collect} />
                          </View>
                      }
                    </View>
                  </View>
                )
              })
            }
          </View>
        </ScrollView>
    )
}

export default GoodsList