import cloud from '@tbmp/mp-cloud-sdk'
import tbccTs from 'tbcc-sdk-ts'
import conifg from './config/config'

const { utils: { generateAPI }, request: tbccRequest, capi, capiFn } = tbccTs
const { cloudName, requestType } = conifg

const request = tbccRequest({
  cloud,
  cloudName,
  requestType
})
/**
 const defaultConfig = {
    method: 'GET',
    showLoading: false,  请求是否loading
    toastError: true  success为false时是否toastMessage
  }
 * **/
// api handle 列表
const apiList = {
  ...capi,
  getActivityBaseInfoById: {
    handle: 'getActivityBaseInfoById',
    method: 'GET',
    isShowLoading: false
  },
  login: 'login',
  getTaskList: 'getTaskList',
  doCompleteTask: 'doCompleteTask',
  receiveTaskRewards: 'receiveTaskRewards',
  addStat: 'addStat',
  doHelp: 'doHelp',
  drawLotteryPrize: 'drawLotteryPrize',
  resetTest: 'resetTest',
  getShareInfo: 'getShareInfo',
  getVipInfo: 'getVipInfo',
  getCollectGoodsList: 'getCollectGoodsList',
  getItemListByItemIds: 'getItemListByItemIds',
  updateEnamePrizeReceived: 'updateEnamePrizeReceived', // 会员权益领取
  getMyPrizeList: 'getMyAwardsList',
  receiveObjectPrize: {
    handle: 'recieveObjectPrize',
    method: 'GET',
    isShowLoading: false,
    toastError: false
  },
  receiveEnamePrize: {
    handle: 'recieveEnamePrize',
    method: 'GET',
    isShowLoading: false,
    toastError: false
  }
}

// 生成API
const API = generateAPI(apiList, request)
API.Fn = capiFn(apiList, request)

export default API
