/** @format */

import { BaseDao } from '../sdk'
import { SELLER_INFO_DB_NAME } from '../db'

// import { DELETE_STATUS, OPEN_PRIZE_STATUS } from '../constants'
export default class ActivitySellerService {
  context: Context
  sellerdao: IBaseDao
  constructor(context: Context) {
    this.sellerdao = new BaseDao(context, SELLER_INFO_DB_NAME)
  }

  //保存商家授权信息
  async saveSellerInfo(sellerInfo: ISellerSaveInfo) {
    return await this.sellerdao.insertOne({
      ...sellerInfo,
      updateTime: Date.now(),
      createTime: Date.now()
    })
  }

  //查找商家授权信息
  async findSellerInfo(openId: string) {
    return await this.sellerdao.findOne({ openId })
  }

  //查找商家授权信息
  async getSellerInfoByUserNick(userNick: string) {
    return await this.sellerdao.findOne({ userNick })
  }

  //更新商家授权信息
  async updateSellerInfo(openId: string, sellerInfo: object) {
    return await this.sellerdao.update(
      { openId },
      {
        $set: { ...sellerInfo, updateTime: Date.now() }
      }
    )
  }
}
