/** @format */

import { CODE_TYPES } from './../constants'
import { services, paramsCheck } from '../decorator'
import { formatTime } from '../utils'
import { resultsModel } from '../sdk'
import { EIGHT_HOURS } from '../constants'
export default class RuleController {
  /**
   *  生成活动规则
   */
  @paramsCheck(['title', 'startTime', 'endTime', 'prizeList'])
  @services([])
  async generateRule(context: Context, {}) {
    const { title = '', startTime = '', endTime = '', prizeList = [] } = context.data

    if (title.length > 12) return resultsModel.error(CODE_TYPES.PARAMS_ERROR, '活动名称不可超过12个字')
    if (startTime > endTime) return resultsModel.error(CODE_TYPES.PARAMS_ERROR, '开始时间不得大于结束时间')
    if (prizeList.length === 0) return resultsModel.error(CODE_TYPES.PARAMS_ERROR, '奖品至少配置一个')

    let resultRule: string = ''
    const startTimeDate = formatTime(new Date(+startTime + EIGHT_HOURS), 'yyyy-MM-dd hh:mm:ss')
    const endTimeDate = formatTime(new Date(+endTime + EIGHT_HOURS), 'yyyy-MM-dd hh:mm:ss')
    resultRule = `1.活动时间：${startTimeDate}--${endTimeDate}；\n2.活动结束根据排行榜排名获得对应的奖励，每个人取活动中单局最高分；\n3.每天3次免费参与资格，超过次数后邀请群内好友参与游戏可获得额外次数(每个用户可助力一次)；\n4.参与签到可获得道具，每局结束游戏后可使用道具；\n5.完成任务每天可获得额外的复活机会，每局只能使用一张复活卡；\n\n`
    const prizeStr = prizeList.reduce((s, v) => {
      const rankArr = v.rank.split('-')
      if (rankArr[0] == rankArr[1]) {
        return (s += `第${rankArr[0]}名:  ${v.name}\n`)
      } else {
        return (s += `第${v.rank}名:  ${v.name}\n`)
      }
    }, '奖品：\n')
    resultRule += prizeStr
    return resultsModel.success(resultRule)
  }
}
