/** @format */

// 排行榜开奖记录

import { BaseDao } from '../sdk'
import { AWARDS_DB_NAME } from '../db'

import { DRAW_STATUS, PRIZE_TYPE, SHIP_STATUS } from '../constants'
export default class AwardsService {
  context: Context
  awardsDao: IBaseDao
  constructor(context: Context) {
    this.awardsDao = new BaseDao(context, AWARDS_DB_NAME)
  }

  // 添加排行榜待开奖列表
  async addWaitAwardsList(list) {
    if (!list.length) return true
    list = list.map(v => {
      return {
        ...v,
        drawStatus: DRAW_STATUS.WAITAWARD,
        message: ''
      }
    })
    try {
      await this.awardsDao.insertMany(list)
      return true
    } catch (e) {
      console.log(`添加排行榜待开奖列表出错：${e}`)
      return false
    }
  }

  async setUserShipStatus(activityId, prizeId, shipCompany, shipNum) {
    prizeId = prizeId ? prizeId : '/'
    shipCompany = shipCompany ? shipCompany : ''
    shipNum = shipNum ? shipNum : ''
    let status = SHIP_STATUS.NO_SHIP
    console.log(shipCompany, shipNum, 'shipCompany,shipNum')
    if (shipCompany && shipNum) {
      status = SHIP_STATUS.HAS_SHIP
    } else {
      status = SHIP_STATUS.NO_SHIP
    }
    if (status == SHIP_STATUS.HAS_SHIP) {
      console.log(activityId, prizeId, PRIZE_TYPE.OBJECT)
      const result = await this.awardsDao.update(
        {
          activityId,
          _id: prizeId,
          type: PRIZE_TYPE.OBJECT,
          shipStatus: SHIP_STATUS.NO_SHIP
        },
        {
          $set: {
            shipCompany,
            shipNum,
            shipStatus: status
          }
        }
      )
      console.log(result, 'result')
      return result
    } else {
      return 0
    }
  }

  // 根据活动id查找中奖名单
  async getAwardListByActivityId({
    activityId = '',
    title = '',
    pageNo = 1,
    pageSize = 10,
    prizeId = null,
    userNick = '',
    type = null,
    prizeDataType = null,
    shipStatus = null,
    startTime = null,
    endTime = null,
    isExport = false
  }) {
    if (!activityId) return false
    let p = prizeId ? { _id: prizeId } : null
    let u = userNick ? { userNick: { $regex: '.*' + userNick + '.*' } } : null
    let c = startTime > 0 && endTime > 0 ? { createTime: { $gt: startTime, $lt: endTime } } : null
    let s = shipStatus
      ? (shipStatus == 1
        ? { shipStatus: { $in: [SHIP_STATUS.NO_ADDRESS] } }
        : (shipStatus == 2
          ? { shipStatus: { $in: [SHIP_STATUS.NO_SHIP] } }
          : { shipStatus: SHIP_STATUS.HAS_SHIP }
        )
      )
      : '';
    let t = type ? { type: +type } : null
    let pt = prizeDataType ? { prizeDataType: +prizeDataType } : null
    let arr = []
    if (p) arr.push(p)
    if (u) arr.push(u)
    if (c) arr.push(c)
    if (s) arr.push(s)
    if (t) arr.push(t)
    if (pt) arr.push(pt)
    arr = arr.filter(i => i)
    console.log('arr--111---', arr, activityId)

    const query = { activityId }
    // @ts-ignore
    if (arr.length > 0) query.$and = arr
    const list = await this.awardsDao.find(query, {
      limit: pageSize,
      skip: (pageNo - 1) * pageSize,
      sort: {
        score: -1,
        rankTime: -1
      }
    })
    const total = await this.awardsDao.count(query)
    return {
      list,
      total,
      message: '成功',
      pageNo,
      pageSize
    }
  }
}
