/**
 * 获取商家session
 *
 * @format
 */

import { SELLER_INFO_DB_NAME, ACTIVITY_CONFIG_DB_NAME } from '../../db'

import { BaseDao } from '../../sdk'

export const getSellerSession = async (context: IContext<IParams>, activityId?: string) => {
  if (!activityId) {
    activityId = context.data.activityId
  }
  let activitydao: IBaseDao = new BaseDao(context, ACTIVITY_CONFIG_DB_NAME)
  let sellerdao: IBaseDao = new BaseDao(context, SELLER_INFO_DB_NAME)
  let activityConfigResult = await activitydao.findOne<IActivityInfo>({ _id: activityId })
  if (!activityConfigResult) return {}

  let result = await sellerdao.findOne<ISellerInfo>({
    openId: activityConfigResult.openId
  })
  //  console.log(`getSellerSession`, result)
  if (!result) return {}
  return {
    session: result.accessToken,
    userNick: result.userNick
  }
}
