/** @format */
interface Context {
  appkey: string
  sourceAppKey: string
  userNick?: string
  mixNick: string
  miniappId: string
  sourceMiniAppId: string
  accessToken: string
  openId: string
  env: string
  traceId: string
  fcName: string
  handler: string
  appOwnerOpenId: string
  fcInvokeId: string
  cloud: any
  data: {
    [queryParam: string]: any
  }
}

interface IControllerInfos {
  userInfo: IUserInfo
  vipInfo: IVipInfo
  activityInfo?: IActivityInfo
  session: string
  noCatch?: boolean
}

interface IVipInfo {
  isVip: boolean
  url?: string
}

interface Result {
  success: boolean
  code: string
  message?: string
  data?: object[] | object | number[] | string[] | boolean
}

interface IBaseDao {
  dbName: string
  db: object
  constructor(context: any, dbName: string)
  /**
   * 查询一条数据
   * @param query
   * @param projection
   */
  findOne(query: object, projection?: object): Promise<any>
  /**
   * 查询多条数据
   * @param query
   * @param projection
   */
  find(query: object, projection?: object): Promise<any>
  /**
   * 插入单条数据
   * @param document
   */
  insertOne(document: object): Promise<any>
  /**
   * 插入多条数据
   * @param documents 插入对象
   */
  insertMany(documents: object[]): Promise<any>
  /**
   * 更新数据
   * @param query
   * @param options
   */
  update(query: object, options?: object): Promise<any>
  /**
   * 删除多条数据
   * @param filter
   */
  delete(filter: object): Promise<any>
  /**
   * 获取条目数
   * @param query
   * @param options
   */
  count(query: object, options?: object): Promise<any>
  /**
   * 聚合查询
   * @param query
   * @param options
   */
  aggregate(aggregateOperation: object | any[]): Promise<any>
}
