/** @format */
interface IActivityInfo {
  _id: string
  openId: string
  rule: string
  startTime: number
  endTime: number
  title: string
  deleteStatus: 1 | 2
  openPrizeStatus?: 1 | 2 | 3 | 4
  remark?: string
  createTime: number
  updateTime: number
  awardReceiveExpiredTime?: number
  tasks?: ITasks
}

interface ITasks {
  attentionStore?: ITaskConfig
  beMembership?: ITaskConfig
  sign?: ITaskConfig
  exchangeCredits?: ITaskConfig
  browseGoods?: ITaskConfig
  orderGoods?: ITaskConfig
  collectGoods?: ITaskConfig
  jumpLink?: ITaskConfig
  inviteFriends?: ITaskConfig
}

interface ITaskConfig {
  title?: string // 任务标题
  value: number // 任奖奖励
  times?: number // 任务为每日限次次数值
  taskRateType?: number // 任务频率类型
  link?: number // 任务链接
  itemIds?: string // 任务商品
  checked?: boolean // 是否选中（B端需勾选时）
}
