/**
 * 基本信息
 *
 * @format
 */

import { BaseDao } from '../sdk'
import { ACTIVITY_CONFIG_DB_NAME } from '../db'

export default class BaseService {
  context: Context
  activitydao: IBaseDao
  constructor(context: Context) {
    this.context = context
    this.activitydao = new BaseDao(context, ACTIVITY_CONFIG_DB_NAME)
  }
  /**
   * @desc 活动基本信息
   * @param {活动id} activityId
   * @returns 返回活动详情，若不存在活动，返回为null
   */
  async getBaseInfo(activityId: string) {
    console.log(process.argv[2], 'process.argv[2]')
    return await this.activitydao.findOne({ _id: activityId })
  }
}
