/** @format */

import { CODE_TYPES } from './../constants'
import { services, paramsCheck } from '../decorator'

import { resultsModel } from '../sdk'
import { BaseService } from '../service'
export default class BaseController {
  /**
   *  活动基本信息
   */
  @paramsCheck(['activityId'])
  @services([BaseService])
  async getActivityBaseInfoById(context: Context, {}, [baseService]: [BaseService]) {
    const { activityId } = context.data
    // 参数校验
    if (!activityId) {
      return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `activityId必填`)
    }
    // 活动基本情况
    const activityInfo = await baseService.getBaseInfo(activityId)
    return resultsModel.success(activityInfo)
  }
}
