/** @format */

import { DEFAULT_CODE_TYPES } from './sdk'

export const BusinessError = {
  // 更新重试失败(用于并发更新)
  ERROR_UPDATE_RETRY: {
    code: `210001`,
    defaultMsg: `系统错误`
  },
  // 活动不存在
  ERROR_NO_ACTIVITY: {
    code: `220001`,
    defaultMsg: `活动不存在`
  },
  // 活动未开始
  ERROR_ACTIVITY_NOSTART: {
    code: `220002`,
    defaultMsg: `活动未开始`
  },
  // 活动已结束
  ERROR_ACTIVITY_OVER: {
    code: `220003`,
    defaultMsg: `活动已结束`
  },
  // 用户不存在
  ERROR_NO_USER: {
    code: `310002`,
    defaultMsg: `用户不存在`
  },
  // 需要成为会员才能助力哦
  ERROR_NEEDMEMBER_DOHELP: {
    code: `310004`,
    defaultMsg: '需要成为会员才能助力哦'
  },
  // 非店铺会员
  ERROR_NO_VIP: {
    code: `310005`,
    defaultMsg: '非店铺会员'
  },
  // 任务奖励已领取
  ERROR_TASK_ALREADYRECEIVE: {
    code: `430002`,
    defaultMsg: `任务奖励已领取`
  },
  // 任务已完成
  ERROR_TASK_COMPLETE: {
    code: `430003`,
    defaultMsg: `任务已完成`
  },
  // 暂无次数可领取
  ERROR_TASK_NORECEIVE: {
    code: `430003`,
    defaultMsg: `暂无次数可领取`
  },
  ERROR_INVALID_INVITE_ID: {
    code: `430004`,
    defaultMsg: `邀请码无效`
  },
  ERROR_NO_CREDITS: {
    code: `430005`,
    defaultMsg: `积分不足`
  },
  ERROR_TASK_LIMIT: {
    code: `430006`,
    defaultMsg: `今日完成该任务次数超限`
  },
  ERROR_FORBIDDEN_OPE: {
    code: `530001`,
    defaultMsg: `非法操作`
  },
  ERROR_RECEIVE_PRIZE: {
    code: `630002`,
    defaultMsg: `奖励已领取`
  },
  ERROR_SEND_PRIZE: {
    code: `730001`,
    defaultMsg: `发奖失败`
  },
  ERROR_NO_PRIZE: {
    code: `730002`,
    defaultMsg: `奖品不存在`
  },
  ERROR_NO_STOCK: {
    code: `730003`,
    defaultMsg: `库存不足`
  },
  ERROR_PRIZE_EXPIRED: {
    code: `740001`,
    defaultMsg: `奖品已超过领取时间`
  }
}

export const CODE_TYPES = Object.assign({}, DEFAULT_CODE_TYPES, BusinessError)

// tb 接口返回部分错误
export const TBERROR = {
  USER_PERMISSION_EXCEED_MAX_RIGHT_COUNT_IN_DAY: '今日领取达到上限，明日再来领取哦',
  COUPON_INVALID_OR_DELETED: '权益无效或者被删除，请联系商家',
  APPLY_OWNSELF_COUPON: '不能领取自己家店铺权益',
  APPLY_SINGLE_COUPON_COUNT_EXCEED_LIMIT: '请至卡券包删除无用权益再领取',
  NO_RIGHT_QUANTITY: '权益库存不足，请联系商家',
  ERRORA_3_567: '领取失败，为风险用户',
  'Invalid session': '订购应用已过期，请联系商家处理'
}

// 领取奖品状态
export const DRAW_STATUS = {
  // 待领取
  WAITAWARD: 1,
  // 处理中
  PROCESSING: 2,
  // 领取成功
  SUCCESS: 3,
  // 领取失败
  FAIL: 4,
  // 已过期
  EXPIRED: 5,
  // 重新领取
  RETRY: 6
}

// 奖品类型
export const PRIZE_TYPE = {
  ENAME: 1,
  CREDITS: 2,
  OBJECT: 3,
  THANKS: 5
}
// C端的APP NAME
export const C_APP_NAME: string = 'promotioncenter-${需要补充}'

// 订单状态
export const TAOBAO_SUCCESS_ORDER_STATUS: string[] = [
  'WAIT_SELLER_SEND_GOODS',
  'SELLER_CONSIGNED_PART',
  'WAIT_BUYER_CONFIRM_GOODS',
  'TRADE_BUYER_SIGNED',
  'TRADE_FINISHED',
  'PAID_FORBID_CONSIGN'
]

// 活动状态
export const enum ACTIVITY_STATUS {
  NORMAL = 1,
  DELETE = 2
}

//任务频率类型常量
export const TASK_RATE_TYPE = {
  FOREVER: 1,
  EVERYDAY: 2,
  NOLIMIT: 3
}

export const RECORD_TYPE = {
  FOLLOW_TASK: { type: 1, name: '关注店铺任务' },
  SIGN_TASK: { type: 2, name: '签到任务' },
  RECEIVE_INVITE: { type: 3, name: '接受邀请' },
  INVITE_SUCCESS: { type: 4, name: '邀请成功' }
}
