/** @format */

var axios = require('axios')
let port = require('../package.json').port || 5555
const request = async (path, params) => {
  let res = await axios({
    method: 'post',
    url: path,
    data: params,
    baseURL: `http://127.0.0.1:${port}`
  })
  if (!res.data.data) {
    console.log(`调用${path}${JSON.stringify(params)}\n返回结果`, res.data)
    return false
  }
  return res.data.data
}

const CURD_REQUEST = async ({ db, TABLE, type, query, options, document }) => {
  // 参数
  let data = {
    dbName: db,
    TABLE,
    query,
    options,
    document
  }
  console.log(`请求参数`, data)
  let path = `/proxy/dataMock/${type}`
  return await request(path, data)
}

const TBAPI_REQUEST = async (db, funName, query) => {
  // 参数
  let data = {
    dbName: db,
    funName
  }
  let path = `/proxy/dataMock/tbapi`
  let params = {
    dbName: data.dbName,
    funName: data.funName,
    query
  }
  return await request(path, params)
}

module.exports = {
  CURD_REQUEST,
  TBAPI_REQUEST
}
