"use strict";
/** @format */
Object.defineProperty(exports, "__esModule", { value: true });
exports.RECORD_TYPE = exports.TASK_RATE_TYPE = exports.TAOBAO_SUCCESS_ORDER_STATUS = exports.C_APP_NAME = exports.PRIZE_TYPE = exports.DRAW_STATUS = exports.TBERROR = exports.CODE_TYPES = exports.BusinessError = void 0;
var sdk_1 = require("./sdk");
exports.BusinessError = {
    // 更新重试失败(用于并发更新)
    ERROR_UPDATE_RETRY: {
        code: "210001",
        defaultMsg: "\u7CFB\u7EDF\u9519\u8BEF"
    },
    // 活动不存在
    ERROR_NO_ACTIVITY: {
        code: "220001",
        defaultMsg: "\u6D3B\u52A8\u4E0D\u5B58\u5728"
    },
    // 活动未开始
    ERROR_ACTIVITY_NOSTART: {
        code: "220002",
        defaultMsg: "\u6D3B\u52A8\u672A\u5F00\u59CB"
    },
    // 活动已结束
    ERROR_ACTIVITY_OVER: {
        code: "220003",
        defaultMsg: "\u6D3B\u52A8\u5DF2\u7ED3\u675F"
    },
    // 用户不存在
    ERROR_NO_USER: {
        code: "310002",
        defaultMsg: "\u7528\u6237\u4E0D\u5B58\u5728"
    },
    // 需要成为会员才能助力哦
    ERROR_NEEDMEMBER_DOHELP: {
        code: "310004",
        defaultMsg: '需要成为会员才能助力哦'
    },
    // 非店铺会员
    ERROR_NO_VIP: {
        code: "310005",
        defaultMsg: '非店铺会员'
    },
    // 任务奖励已领取
    ERROR_TASK_ALREADYRECEIVE: {
        code: "430002",
        defaultMsg: "\u4EFB\u52A1\u5956\u52B1\u5DF2\u9886\u53D6"
    },
    // 任务已完成
    ERROR_TASK_COMPLETE: {
        code: "430003",
        defaultMsg: "\u4EFB\u52A1\u5DF2\u5B8C\u6210"
    },
    // 暂无次数可领取
    ERROR_TASK_NORECEIVE: {
        code: "430003",
        defaultMsg: "\u6682\u65E0\u6B21\u6570\u53EF\u9886\u53D6"
    },
    ERROR_INVALID_INVITE_ID: {
        code: "430004",
        defaultMsg: "\u9080\u8BF7\u7801\u65E0\u6548"
    },
    ERROR_NO_CREDITS: {
        code: "430005",
        defaultMsg: "\u79EF\u5206\u4E0D\u8DB3"
    },
    ERROR_TASK_LIMIT: {
        code: "430006",
        defaultMsg: "\u4ECA\u65E5\u5B8C\u6210\u8BE5\u4EFB\u52A1\u6B21\u6570\u8D85\u9650"
    },
    ERROR_FORBIDDEN_OPE: {
        code: "530001",
        defaultMsg: "\u975E\u6CD5\u64CD\u4F5C"
    },
    ERROR_RECEIVE_PRIZE: {
        code: "630002",
        defaultMsg: "\u5956\u52B1\u5DF2\u9886\u53D6"
    },
    ERROR_SEND_PRIZE: {
        code: "730001",
        defaultMsg: "\u53D1\u5956\u5931\u8D25"
    },
    ERROR_NO_PRIZE: {
        code: "730002",
        defaultMsg: "\u5956\u54C1\u4E0D\u5B58\u5728"
    },
    ERROR_NO_STOCK: {
        code: "730003",
        defaultMsg: "\u5E93\u5B58\u4E0D\u8DB3"
    },
    ERROR_PRIZE_EXPIRED: {
        code: "740001",
        defaultMsg: "\u5956\u54C1\u5DF2\u8D85\u8FC7\u9886\u53D6\u65F6\u95F4"
    }
};
exports.CODE_TYPES = Object.assign({}, sdk_1.DEFAULT_CODE_TYPES, exports.BusinessError);
// tb 接口返回部分错误
exports.TBERROR = {
    USER_PERMISSION_EXCEED_MAX_RIGHT_COUNT_IN_DAY: '今日领取达到上限，明日再来领取哦',
    COUPON_INVALID_OR_DELETED: '权益无效或者被删除，请联系商家',
    APPLY_OWNSELF_COUPON: '不能领取自己家店铺权益',
    APPLY_SINGLE_COUPON_COUNT_EXCEED_LIMIT: '请至卡券包删除无用权益再领取',
    NO_RIGHT_QUANTITY: '权益库存不足，请联系商家',
    ERRORA_3_567: '领取失败，为风险用户',
    'Invalid session': '订购应用已过期，请联系商家处理'
};
// 领取奖品状态
exports.DRAW_STATUS = {
    // 待领取
    WAITAWARD: 1,
    // 处理中
    PROCESSING: 2,
    // 领取成功
    SUCCESS: 3,
    // 领取失败
    FAIL: 4,
    // 已过期
    EXPIRED: 5,
    // 重新领取
    RETRY: 6
};
// 奖品类型
exports.PRIZE_TYPE = {
    ENAME: 1,
    CREDITS: 2,
    OBJECT: 3,
    THANKS: 5
};
// C端的APP NAME
exports.C_APP_NAME = 'promotioncenter-${需要补充}';
// 订单状态
exports.TAOBAO_SUCCESS_ORDER_STATUS = [
    'WAIT_SELLER_SEND_GOODS',
    'SELLER_CONSIGNED_PART',
    'WAIT_BUYER_CONFIRM_GOODS',
    'TRADE_BUYER_SIGNED',
    'TRADE_FINISHED',
    'PAID_FORBID_CONSIGN'
];
//任务频率类型常量
exports.TASK_RATE_TYPE = {
    FOREVER: 1,
    EVERYDAY: 2,
    NOLIMIT: 3
};
exports.RECORD_TYPE = {
    FOLLOW_TASK: { type: 1, name: '关注店铺任务' },
    SIGN_TASK: { type: 2, name: '签到任务' },
    RECEIVE_INVITE: { type: 3, name: '接受邀请' },
    INVITE_SUCCESS: { type: 4, name: '邀请成功' }
};
//# sourceMappingURL=constants.js.map