function loginfo(context, handler) {
  const {
    fcName,
    data,
    env
  } = context;
  console.log(`函数名:${fcName}---函数handler:${handler}---当前环境:${env}---请求参数:${JSON.stringify(data)}`)
}

const passUrlList = [
  '1688.cn',
  'taobao.cn',
  'taobao.com',
  'taobao.net',
  'tb.cn',
  'tmall.com',
  'zhifu.com',
  'zhifubao.com',
  'juhuasuan.com',
  'tmall.hk',
  'tmall.com.hk',
  'dingtalk.com',
  'yushanfang.com',
  'guoguo-app.com',
  'umeng.com'
]
/**
 * 传入时间戳（毫秒）
 * 根据时间戳转换成number型日期进行差值结算，比如：2020318-2020317
 */
function isNewDay(time) {
  let date = new Date(time);
  let dateNum = +(date.getFullYear() + "" + (date.getMonth() + 1) + "" + date.getDate());

  let nowdate = new Date(Date.now());
  let nowdateNum = +(nowdate.getFullYear() + "" + (nowdate.getMonth() + 1) + "" + nowdate.getDate());
  return nowdateNum - dateNum > 0
}

const formatTime = function dateFormat(thisDate, fmt = "yyyy-MM-dd hh:mm:ss") {
  var o = {
    "M+": thisDate.getMonth() + 1,
    "d+": thisDate.getDate(),
    "h+": thisDate.getHours(),
    "m+": thisDate.getMinutes(),
    "s+": thisDate.getSeconds(),
    "q+": Math.floor((thisDate.getMonth() + 3) / 3),
    "S": thisDate.getMilliseconds()
  };
  if (/(y+)/.test(fmt))
    fmt = fmt.replace(RegExp.$1, (thisDate.getFullYear() + "").substr(4 - RegExp.$1.length));
  for (var k in o)
    if (new RegExp("(" + k + ")").test(fmt))
      fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
  return fmt;
}

function MathRand() {
  var Num = "";
  for (var i = 0; i < 6; i++) {
    Num += Math.floor(Math.random() * 10);
  }
  return Num;
}

module.exports = {
  loginfo,
  MathRand,
  passUrlList,
  isNewDay,
  formatTime
}