const { BaseDao, TBAPI, Utils } = require("taobao-mini-sdk").default;
// 活动开奖状态码
const OPEN_PRIZE_STATUS = {
  // 待开奖
  WAIT_AWARD: 1,
  // 开奖中
  PROCESSING: 2,
  // 开奖成功
  SUCCESS: 3,
  // 开奖失败
  FAIL: 4,
};

// 领取奖品状态
const DRAW_STATUS = {
  // 待领取
  WAITAWARD: 1,
  // 处理中
  PROCESSING: 2,
  // 领取成功
  SUCCESS: 3,
  // 领取失败
  FAIL: 4,
  // 已过期
  EXPIRED: 5,
  // 重新领取
  RETRY: 6,
};

// 日志类型： error，info
const LOGGER_TYPE = {
  ERROR: 1,
  INFO: 2,
};

const PRIZE_TYPE = {
  EQUITY: 1,
  CREDITS: 2,
  OBJECT: 3,
  THANK: 5,
};

// code类型
const CODE_TYPES = {
  PARAMS_ERROR: {
    code: "100000",
    defaultMsg: `参数错误`,
  },
  SYSTEM_ERROR: {
    code: "500000",
    defaultMsg: `系统错误`,
  },
  SUCCESS: {
    code: "000000",
    defaultMsg: `成功`,
  },
  // TODO 补充业务类型错误, 固定以2开头，如B端业务错误：200001，200002，C端业务错误：210001，210002
};

const SHARE_TOTAL_COUNT = 5; //验证要求5人后，完成分享任务

const B_APP_NAME = "promotioncenter-<%=bizCode%>"; // B端的APP NAME

const GOODSINFO =
  "detail_url,approve_status,num_iid,title,nick,type,cid,pic_url,num,props,valid_thru,list_time,price,has_discount,has_invoice,has_warranty,has_showcase,modified,delist_time,postage_id,seller_cids,outer_id,sold_quantity";

const EIGHT_HOURS = 60 * 60 * 8 * 1000;

const DELETE_STATUS = {
  DELETE: 2,
  EXIST: 1,
};

const TEMPLATE_INFO = {
  clients: "taobao,tmall",
  template_id: 3000000002590532,
  template_version: "0.0.3",
};

const TASK_TYPE_CHINA = {
  beMembership: "成为会员",
  attentionStore: "关注店铺",
  sign: "签到",
  exchangeCredits: "兑换积分",
  inviteFriends: "邀请好友",
  orderGoods: "下单商品",
  browseGoods: "浏览商品",
  jumpLink: "跳转链接",
  collectGoods: "收藏商品",
};
const TASK_CHECK_TYPE = {
  value: {
    list: [
      "beMembership",
      "attentionStore",
      "sign",
      "exchangeCredits",
      "inviteFriends",
      "orderGoods",
      "jumpLink",
      "collectGoods",
    ],
    reg: /[1-99]/,
    regName: "1-99之内",
  },
  times: {
    list: [
      "exchangeCredits",
      "inviteFriends",
      "orderGoods",
      "browseGoods",
      "jumpLink",
      "collectGoods",
    ],
  },
  title: {
    list: [
      "inviteFriends",
      "orderGoods",
      "browseGoods",
      "jumpLink",
      "collectGoods",
    ],
  },
  itemIds: {
    list: ["orderGoods", "browseGoods", "collectGoods"],
  },
  taskRateType: {
    list: ["inviteFriends", "orderGoods", "browseGoods", "collectGoods"],
  },
  link: { list: ["jumpLink"] },
};

//店铺漂流记订购码
const APP_SUB_CODE = "FW_GOODS-1001086450";

module.exports = {
  OPEN_PRIZE_STATUS,
  DRAW_STATUS,
  LOGGER_TYPE,
  CODE_TYPES,
  SHARE_TOTAL_COUNT,
  DELETE_STATUS,
  GOODSINFO,
  B_APP_NAME,
  EIGHT_HOURS,
  TEMPLATE_INFO,
  BaseDao,
  TBAPIS: TBAPI.default,
  Utils,
  TASK_CHECK_TYPE,
  TASK_TYPE_CHINA,
  APP_SUB_CODE,
  PRIZE_TYPE,
};
