const {
  ACTIVITY_SELLER_SAVE,
  ACTIVITY_BASE_CONFIG,
} = require("../config/db_config");
const {
  getConsumerSeller,
  getSellerInfoByContext,
} = require("../config/seller_config");
const {
  CODE_TYPES,
  GOODSINFO,
  B_APP_NAME,
  TEMPLATE_INFO,
  TBAPIS,
  APP_SUB_CODE,
} = require("../utils/constants");
const ResultsModel = require("../utils/results.model");
const { MathRand } = require("../utils/utils");
let resultsModel = new ResultsModel();
const BaseDao = require("../dao/base.dao");
class ActivityTopService {
  constructor(context) {
    this.activitySellerDao = new BaseDao(context, ACTIVITY_SELLER_SAVE);
    this.activityBaseDao = new BaseDao(context, ACTIVITY_BASE_CONFIG);
    this.context = context;
  }

  //获取商家授权session
  async getAccessToken(activityId) {
    let result = await this.activityBaseDao.find({
      _id: activityId,
    });
    if (result[0]) {
      let shopId = result[0].shopId;
      let sellResult = await this.activitySellerDao.find(
        {
          shopId,
        },
        {
          sort: {
            createTime: 1,
          },
        }
      );
      console.log(sellResult, "sellResult");
      if (sellResult[0]) {
        let { accessToken } = sellResult[0];
        return {
          session: accessToken,
        };
      }
    }
  }

  //通过openId去查找session
  async getAccessTokenByOpenId() {
    let openId = this.context.openId;
    let result = await this.activitySellerDao.find({
      openId,
    });
    return { session:(result.length && result[0].accessToken) || this.context.accessToken };
  }

  //淘宝top接口获取商品列表
  async getItemListByIds(activityId, itemIds) {
    let sellerConfig;
    if (activityId) {
      let businessSeller = await this.getAccessToken(activityId);
      sellerConfig = getConsumerSeller(businessSeller);
    } else {
      sellerConfig = await this.getAccessTokenByOpenId();
      itemIds = this.context.data.itemIds;
    }
    console.log(sellerConfig, "sellerConfig");
    try {
      let result = await TBAPIS.getItemListByItemIds(
        this.context,
        sellerConfig.session,
        itemIds,
        { fields: GOODSINFO }
      );
      // let result = await this.context.cloud.topApi.invoke({
      //   api: "taobao.items.seller.list.get",
      //   data: {
      //     ...sellerConfig,
      //     fields: GOODSINFO,
      //     num_iids: itemIds,
      //   },
      // });
      // console.log(JSON.stringify(result), '获取商品通过ids')
      if (result) {
        let itemsData = {
          list:
            (result &&
              result.items &&
              result.items.item.reduce((s, v) => {
                return (s = [
                  ...s,
                  {
                    itemId: v.num_iid,
                    name: v.title,
                    price: v.price,
                    detailUrl: v.detail_url,
                    picUrl: v.pic_url,
                  },
                ]);
              }, [])) ||
            [],
          totalCount: result.items.item.length,
        };
        return resultsModel.success(itemsData);
      }
      return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "获取商家ids列表失败");
    } catch (e) {
      console.log(e, "获取ids商品列表失败");
      return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, "获取商家ids列表失败");
    }
  }

  //淘宝top接口获取权益商品信息
  async getPrizeByEname(activityId, ename) {
    let sellerConfig;
    if (activityId) {
      let businessSeller = await this.getAccessToken(activityId);
      sellerConfig = getConsumerSeller(businessSeller);
    } else {
      sellerConfig = await this.getAccessTokenByOpenId();
      ename = this.context.data.ename;
    }
    console.log(sellerConfig, "sellerConfig");
    try {
      let benefitData = await TBAPIS.getPrizeByEname(
        this.context,
        sellerConfig.session,
        ename,
        B_APP_NAME
      );
      console.log(benefitData, benefitData.result, "benefitData.result.");
      if (benefitData.result.success) {
        const { result } = benefitData;
        let data =
          result.datas &&
          result.datas["oright_dto"].reduce((s, v) => {
            return (s = [
              ...s,
              {
                benefitName: v.benefit_name,
                rightTypeId: v.right_type_id == 3 ? 1 : v.right_type_id,
                startTime: new Date(v.start_date).getTime(),
                endTime: new Date(v.end_date).getTime(),
                amount: v.amount ? v.amount / 100 + "" : "",
              },
            ]);
          }, []);
        console.log(JSON.stringify(result), "alibaba.benefit.query");
        return resultsModel.success(data);
      }
      return resultsModel.error(
        CODE_TYPES.SYSTEM_ERROR,
        "获取ename商品信息失败"
      );
    } catch (e) {
      console.log(e, "权益获取失败");
      return resultsModel.error(
        CODE_TYPES.SYSTEM_ERROR,
        "获取ename商品信息失败"
      );
    }
  }

  //淘宝top接口获取店铺会员链接
  async getVipUrlByActivity(activityId) {
    let businessSeller = await this.getAccessToken(activityId);
    let consumerSellerInfo = getConsumerSeller(businessSeller);
    try {
      let result = await this.context.cloud.topApi.invoke({
        api: "taobao.crm.member.joinurl.get",
        data: {
          ...consumerSellerInfo,
          extra_info: {
            source: "isvapp",
            activityId: activityId,
            entrance: "duiba",
          },
        },
      });
      if (result) {
        return resultsModel.success(result);
      }
      console.log(JSON.stringify(result), "获取商家会员链接");
      return resultsModel.error(
        CODE_TYPES.SYSTEM_ERROR,
        "获取商家会员链接失败"
      );
    } catch (e) {
      console.log(e, "获取商家会员链接失败");
      return resultsModel.error(
        CODE_TYPES.SYSTEM_ERROR,
        "获取商家会员链接失败"
      );
    }
  }

  //淘宝top接口获取店铺信息
  async getShopId() {
    let sellerInfo = await this.getAccessTokenByOpenId();
    console.log(sellerInfo, "getShopId sellerInfo");
    try {
      let result = await TBAPIS.getShopInfo(this.context, {
        session: sellerInfo.session,
        fields: "sid,title,pic_path",
      });
      console.log(result, "getShopId result");
      if (result) {
        return resultsModel.success(result.shop);
      } else {
        return resultsModel.error(
          CODE_TYPES.SYSTEM_ERROR,
          "获取淘宝top店铺信息失败"
        );
      }
    } catch (e) {
      console.log(e, "获取店铺信息失败");
      return resultsModel.error(
        CODE_TYPES.SYSTEM_ERROR,
        "获取淘宝top店铺信息失败"
      );
    }
  }

  async getItemListByStatus() {
    let sellerConfig = await this.getAccessTokenByOpenId();
    const {
      approveStatus = "onsale",
      title = "",
      pageNo = 1,
      pageSize = 10,
    } = this.context.data;
    let data = {
      fields: GOODSINFO,
      page_no: pageNo,
      q: title,
      page_size: pageSize,
      ...sellerConfig,
    };
    console.log(data, "data");
    try {
      let result =
        approveStatus === "onsale"
          ? await TBAPIS.getItemListOnSale(this.context, data)
          : await TBAPIS.getItemListInStock(this.context, data);
      if (result) {
        // console.log(
        //   JSON.stringify(result),
        //   `comming ${approveStatus}`,
        //   "success"
        // );
        let { items, total_results } = result;
        let itemsData = {
          pageNo,
          pageSize,
          totalPages: Math.ceil(total_results / pageSize),
          totalCount: total_results,
          list:
            (items &&
              items.item &&
              items.item.reduce((s, v) => {
                return (s = [
                  ...s,
                  {
                    itemId: v.num_iid,
                    name: v.title,
                    price: v.price,
                    approveStatus: v.approveStatus || approveStatus,
                    picUrl: v.pic_url,
                  },
                ]);
              }, [])) ||
            [],
        };
        return resultsModel.success(itemsData);
      }
      return resultsModel.error(
        CODE_TYPES.SYSTEM_ERROR,
        "获取商家在售列表失败"
      );
    } catch (e) {
      console.log(e, "获取商家在售列表失败");
      return resultsModel.error(
        CODE_TYPES.SYSTEM_ERROR,
        "获取商家在售列表失败"
      );
    }
  }

  async getTemplateInstantiate() {
    let sellerConfig = await this.getAccessTokenByOpenId();
    let data = {
      description:
        "此应用用于商家引导活动，商家可设置对应的奖品，在一定时间 内出奖，提升店铺用户活跃以及引导购买",
      ext_json: {
        name: "online",
      },
      icon:
        "https://ossgw.alicdn.com/taobao-miniapp/img/0193eaa9cc037b568acd9ccfe68a8499.jpg",
      name: "店铺漂流" + MathRand(),
      ...TEMPLATE_INFO,
      ...sellerConfig,
    };
    console.log("getTemplateInstantiateParams", data);
    try {
      let result = await TBAPIS.getTemplateInstantiate(this.context, data);
      if (result) {
        console.log(JSON.stringify(result), "getTemplateInstantiate");
        return result;
      }
      return false;
    } catch (e) {
      console.log(e, "获取getTemplateInstantiate失败");
      return false;
    }
  }

  //模板小程序上线
  async pushOnlineInstance(instanceInfo) {
    let sellerConfig = await this.getAccessTokenByOpenId();
    let data = {
      ...TEMPLATE_INFO,
      ...instanceInfo,
      ...sellerConfig,
    };
    console.log("pushOnlineInstanceParams", data);
    try {
      let result = await TBAPIS.pushInstanceOnline(this.context, data);
      if (result) {
        console.log(JSON.stringify(result), "pushOnlineInstance");
        return result;
      }
      return false;
    } catch (e) {
      console.log(e, "pushOnlineInstance失败");
      return false;
    }
  }

  async getSubRelationship(nick) {
    const cloud = this.context.cloud;
    let res = await cloud.topApi.invoke({
      api: "taobao.vas.subscribe.get",
      data: {
        article_code: APP_SUB_CODE,
        nick,
      },
    });
    if (
      res &&
      res["article_user_subscribes"] &&
      res["article_user_subscribes"]["article_user_subscribe"]
    )
      return res["article_user_subscribes"]["article_user_subscribe"][0];
    return false;
  }

  //模板小程序更新
  async updateMiniInstance(instanceInfo) {
    let sellerConfig = await this.getAccessTokenByOpenId();
    let data = {
      ...TEMPLATE_INFO,
      ...instanceInfo,
      ...sellerConfig,
    };
    try {
      let result = await TBAPIS.updateMiniInstance(this.context, data);
      if (result) {
        console.log(JSON.stringify(result), "updateMiniInstance");
        return result;
      }
      return false;
    } catch (e) {
      console.log(e, "updateMiniInstance失败");
      return false;
    }
  }
}

module.exports = ActivityTopService;
