const BaseDao = require("../dao/base.dao");
const { OPEN_PRIZE_STATUS, DELETE_STATUS } = require("../utils/constants");
const { ACTIVITY_PRIZE_CONFIG } = require("../config/db_config");
const DBName = ACTIVITY_PRIZE_CONFIG;
class ActivityprizeService {
  constructor(context) {
    this.activityprizeDao = new BaseDao(context, DBName);
  }
  // 根据活动id查询奖品列表
  async getPrizeListByActivityId(activityId) {
    console.log(13, activityId);
    return await this.activityprizeDao.find({
      activityId,
      deleteStatus: DELETE_STATUS.EXIST,
    });
  }
}
module.exports = ActivityprizeService;
