/**
 * 中奖名单 及导出中奖名单
 */

const RankopenprizeService = require('../service/rankopenprize.service');
const ResultsModel = require('../utils/results.model');
const {
    CODE_TYPES
} = require('../utils/constants');
const xlsx = require('node-xlsx');

let resultsModel = new ResultsModel();

// 活动中奖名单
const findWinnerInfoList = async (context) => {
    let {
        activityId
    } = context.data;
    if (!activityId) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `缺少activityId`);
    }
    let rankopenprizeService = new RankopenprizeService(context);
    // 获取活动中奖列表
    let awardslist = await rankopenprizeService.getAwardslistByActivityId(activityId);
    console.log(`awardslist: ${JSON.stringify(awardslist)}`);
    let winnersObj = {};
    awardslist.forEach((v, index, arr) => {
        if (!winnersObj[v.rank]) {
            winnersObj[v.rank] = [];
        }
        winnersObj[v.rank].push({
            userNick: v.userNick,
            id: v.openId
        });
    });

    console.log(`winnersObj: ${JSON.stringify(winnersObj)}`);
    let results = [];
    new Map(Object.entries(winnersObj)).forEach((v, index, arr) => {
        results.push({
            rank: index,
            winnerDetailList: v
        });
    });
    return resultsModel.success(results);
}


// 导出活动中奖名单
const exportAwardsList = async (context) => {
    let {
        cloud
    } = context;
    let {
        activityId,
        title
    } = context.data;
    if (!activityId) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `缺少activityId`);
    }
    if (!title) {
        return resultsModel.error(CODE_TYPES.PARAMS_ERROR, `缺少title`);
    }
    let rankopenprizeService = new RankopenprizeService(context);
    // 获取活动中奖列表
    let awardslist = await rankopenprizeService.getAwardslistByActivityId(activityId);
    console.log(`awardslist: ${JSON.stringify(awardslist)}`);

    let xlsxData = [
        ['序列', '名次', '昵称', '中奖名称']
    ];
    awardslist.forEach((v, index, arr) => {
        xlsxData.push([index + 1, v.rank, v.userNick, v.prizeName]);
    });
    let buffer = xlsx.build([{
        name: title + new Date().getTime(),
        data: xlsxData
    }]);
    console.log(`xlsxData: ${JSON.stringify(xlsxData)}`);
    try {
        let result = await cloud.file.uploadFile({
            fileContent: buffer,
            fileName: title + new Date().getTime() + '.xlsx'
        });
        // result.url 需进行处理
        if (result.url) {
            result.url = result.url.replace('http', 'https').replace('-internal', '');
        }
        return resultsModel.success(result);
    } catch (e) {
        console.log('上传文件出错', e);
        // 打印日志
        return resultsModel.error(CODE_TYPES.SYSTEM_ERROR, `上传文件错误`);
    }
}

module.exports = {
    findWinnerInfoList,
    exportAwardsList
}